/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.repository.local.dao.internal.backgroundlist;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.util.AbstractList;
import java.util.logging.Logger;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.palladiosimulator.edp2.repository.local.dao.internal.backgroundlist.BackgroundMemoryList;
import org.palladiosimulator.edp2.repository.local.dao.internal.backgroundlist.ChunkedFile;
import org.palladiosimulator.edp2.repository.local.dao.internal.backgroundlist.serializer.Serializer;
import org.palladiosimulator.measurementframework.measure.IdentifierMeasure;
import org.palladiosimulator.metricspec.Identifier;

public class BackgroundMemoryListImpl<V, Q extends Quantity>
extends AbstractList<Measure<V, Q>>
implements BackgroundMemoryList<V, Q> {
    private static final String ACCESS_MODIFIER_READ_WRITE = "rw";
    private static final transient Logger LOGGER = Logger.getLogger(BackgroundMemoryListImpl.class.getName());
    public static final int DEFAULT_CHUNK_SIZE = 10000;
    private transient ChunkedFile<V> chunks = null;
    private String absoluteFilename = null;
    private transient RandomAccessFile raf = null;
    transient boolean closed = true;
    private Serializer<V> serialiser;
    private int listSize;
    private int chunkSize;
    private BinaryRepresentation binaryRepresentation;
    private Unit<Q> unit;

    public BackgroundMemoryListImpl(String absoluteFilename, Serializer<V> serialiser, BinaryRepresentation binaryRepresentation, Unit<Q> unit) throws IOException {
        this(absoluteFilename, serialiser, 10000, binaryRepresentation, unit);
    }

    public BackgroundMemoryListImpl(String absoluteFilename, Serializer<V> serialiser, int chunkSize, BinaryRepresentation binaryRepresentation, Unit<Q> unit) throws IOException {
        this.absoluteFilename = absoluteFilename;
        this.serialiser = serialiser;
        this.chunkSize = chunkSize;
        this.binaryRepresentation = binaryRepresentation;
        this.unit = unit;
        this.open();
        this.listSize = (int)this.chunks.getElementsInFile();
    }

    @Override
    public synchronized void open() throws IOException {
        if (!this.closed) {
            String msg = "Tried to open an already open background list.";
            LOGGER.warning("Tried to open an already open background list.");
            throw new IllegalStateException("Tried to open an already open background list.");
        }
        this.raf = new RandomAccessFile(this.absoluteFilename, ACCESS_MODIFIER_READ_WRITE);
        this.chunks = new ChunkedFile<V>(this.raf, this.serialiser, this.chunkSize);
        this.closed = false;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void add(int index, Measure<V, Q> element) {
        if (this.closed) {
            String msg = "Tried to add data to a closed background list.";
            LOGGER.severe("Tried to add data to a closed background list.");
            throw new IllegalStateException("Tried to add data to a closed background list.");
        }
        if (index != this.listSize) {
            String msg = "The background list currently only supports adding elements at the end of the list";
            LOGGER.info("The background list currently only supports adding elements at the end of the list");
            throw new IllegalArgumentException("The background list currently only supports adding elements at the end of the list");
        }
        if (element == null) {
            String msg = "Null values must not be added to the list.";
            LOGGER.severe("Null values must not be added to the list.");
            throw new IllegalArgumentException("Null values must not be added to the list.");
        }
        try {
            this.ensureCorrectChunkLoaded(index);
            this.chunks.add(element.getValue());
            ++this.listSize;
            if (this.chunks.isFull()) {
                this.chunks.saveChunk();
                this.chunks.createChunk();
            }
        }
        catch (IOException ex) {
            String msg = "Error during IO of background list for file \"" + this.absoluteFilename + "\"";
            LOGGER.severe(msg);
            throw new RuntimeException(msg, ex);
        }
    }

    @Override
    public synchronized Measure<V, Q> get(int index) {
        if (this.closed) {
            String msg = "Tried to get data from a closed background list.";
            LOGGER.severe("Tried to get data from a closed background list.");
            throw new IllegalStateException("Tried to get data from a closed background list.");
        }
        if (index < 0 || index >= this.size()) {
            String msg = index >= this.size() ? "Tried to get data element beyond the number of elements in the background list." : "Tried to get data element with a negative index from the background list.";
            LOGGER.severe(msg);
            throw new ArrayIndexOutOfBoundsException(msg);
        }
        try {
            this.ensureCorrectChunkLoaded(index);
            if (this.binaryRepresentation == BinaryRepresentation.LONG) {
                return Measure.valueOf((long)((Long)this.chunks.get((int)((long)index - this.chunks.indexStartingElementForChunk()))), this.unit);
            }
            if (this.binaryRepresentation == BinaryRepresentation.DOUBLE) {
                return Measure.valueOf((double)((Double)this.chunks.get((int)((long)index - this.chunks.indexStartingElementForChunk()))), this.unit);
            }
            if (this.binaryRepresentation == BinaryRepresentation.IDENTIFIER) {
                return new IdentifierMeasure((Identifier)this.chunks.get((int)((long)index - this.chunks.indexStartingElementForChunk())), this.unit);
            }
            throw new UnsupportedOperationException("Unsupported Binary Representation found");
        }
        catch (IOException ex) {
            String msg = "Error during IO of background list for file \"" + this.absoluteFilename + "\"";
            LOGGER.severe(msg);
            throw new RuntimeException(msg, ex);
        }
    }

    @Override
    public Measure<V, Q> set(int index, Measure<V, Q> element) {
        if (this.closed) {
            String msg = "Tried to get data to a closed background list.";
            LOGGER.severe("Tried to get data to a closed background list.");
            throw new IllegalStateException("Tried to get data to a closed background list.");
        }
        if (index < 0 || index >= this.size()) {
            String msg = index >= this.size() ? "Tried to set data element beyond the number of elements in the background list." : "Tried to set data element with a negative index from the background list.";
            LOGGER.severe(msg);
            throw new ArrayIndexOutOfBoundsException(msg);
        }
        try {
            this.ensureCorrectChunkLoaded(index);
            Object newValue = element.getValue();
            Object oldValue = this.chunks.set((int)((long)index - this.chunks.indexStartingElementForChunk()), newValue);
            if (this.binaryRepresentation == BinaryRepresentation.LONG) {
                return Measure.valueOf((long)((Long)oldValue), this.unit);
            }
            if (this.binaryRepresentation == BinaryRepresentation.DOUBLE) {
                return Measure.valueOf((double)((Double)oldValue), this.unit);
            }
            if (this.binaryRepresentation == BinaryRepresentation.IDENTIFIER) {
                return new IdentifierMeasure((Identifier)oldValue, this.unit);
            }
            throw new UnsupportedOperationException("Unsupported Binary Representation found");
        }
        catch (IOException ex) {
            String msg = "Error during IO of background list for file \"" + this.absoluteFilename + "\"";
            LOGGER.severe(msg);
            throw new RuntimeException(msg, ex);
        }
    }

    @Override
    public Measure<V, Q> remove(int index) {
        throw new UnsupportedOperationException();
    }

    private void ensureCorrectChunkLoaded(int dataIndex) throws IOException {
        if (this.chunks.acceptsDataElementIndex(dataIndex)) {
            return;
        }
        if (this.chunks.isChunkLoaded() && this.chunks.isChanged()) {
            this.chunks.saveChunk();
        }
        this.chunks.loadChunkForElement(dataIndex);
    }

    @Override
    public synchronized int size() {
        return this.listSize;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            String msg = "Tried to close a closed list.";
            LOGGER.warning("Tried to close a closed list.");
            throw new IllegalStateException("Tried to close a closed list.");
        }
        if (!this.closed) {
            if (this.chunks.isChunkLoaded() && this.chunks.isChanged()) {
                this.chunks.saveChunk();
            }
            this.raf.close();
            this.closed = true;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.open();
        if (this.chunks.getElementsInFile() != (long)this.listSize) {
            String msg = "Number of elements of this list and elements saved to file on background mismatch.";
            LOGGER.severe("Number of elements of this list and elements saved to file on background mismatch.");
        }
        this.listSize = (int)this.chunks.getElementsInFile();
    }

    @Override
    public void flush() throws IOException {
        if (this.chunks.isChunkLoaded() && this.chunks.isChanged()) {
            this.chunks.saveChunk();
        }
    }

    public static enum BinaryRepresentation {
        LONG,
        DOUBLE,
        IDENTIFIER;

    }
}

