/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.ui.views.navigator;

import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.palladiosimulator.edp2.EDP2Plugin;
import org.palladiosimulator.edp2.dao.exception.DataNotAccessibleException;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.models.Repository.RepositoryPackage;
import org.palladiosimulator.edp2.ui.views.navigator.NavigatorDoubleClickListener;
import org.palladiosimulator.edp2.ui.views.navigator.NavigatorTreeFactoryImpl;
import org.palladiosimulator.edp2.ui.views.navigator.NavigatorTreeLabelProviderImpl;
import org.palladiosimulator.edp2.ui.views.navigator.NavigatorTreeStructureAdvisorImpl;
import org.palladiosimulator.edp2.util.MeasurementsUtility;

public class Navigator
extends ViewPart
implements ITabbedPropertySheetPageContributor {
    private TreeViewer treeViewer;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.treeViewer = new TreeViewer(parent, 65536);
        this.treeViewer.setAutoExpandLevel(8);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer, (int)2);
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider((IObservableFactory)new NavigatorTreeFactoryImpl(), (TreeStructureAdvisor)new NavigatorTreeStructureAdvisorImpl());
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        IObservableSet set = contentProvider.getKnownElements();
        IObservableMap[] map = new IObservableMap[]{EMFProperties.value((EStructuralFeature)RepositoryPackage.Literals.LOCAL_MEMORY_REPOSITORY__DOMAIN).observeDetail(set)};
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new NavigatorTreeLabelProviderImpl(map));
        IEMFListProperty nodes = EMFProperties.list((EStructuralFeature)RepositoryPackage.Literals.REPOSITORIES__AVAILABLE_REPOSITORIES);
        this.treeViewer.setInput((Object)nodes.observe((Object)EDP2Plugin.INSTANCE.getRepositories()));
        this.treeViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                if (e.keyCode == 127) {
                    IStructuredSelection selection = (IStructuredSelection)Navigator.this.treeViewer.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    this.handleDelete(selection);
                }
            }

            private void handleDelete(IStructuredSelection selection) {
                if (selection instanceof TreeSelection) {
                    TreeSelection treeSelection = (TreeSelection)selection;
                    Repository repo = (Repository)treeSelection.getFirstElement();
                    try {
                        MeasurementsUtility.ensureClosedRepository((Repository)repo);
                        EDP2Plugin.INSTANCE.getRepositories().getAvailableRepositories().remove((Object)repo);
                    }
                    catch (DataNotAccessibleException e) {
                        throw new RuntimeException("Could not close EDP data source");
                    }
                }
            }
        });
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)new NavigatorDoubleClickListener());
        this.treeViewer.addDragSupport(4, new Transfer[]{LocalSelectionTransfer.getTransfer()}, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                event.doit = true;
            }

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)Navigator.this.treeViewer.getSelection();
                LocalSelectionTransfer.getTransfer().setSelection((ISelection)selection);
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public String getContributorId() {
        return "org.palladiosimulator.edp2.ui.propertyContributor";
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(adapter);
    }

    public void collapseTree() {
        this.treeViewer.collapseAll();
    }

    public void expandTree() {
        this.treeViewer.expandAll();
    }
}

