/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.ui.wizards.datasource;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.palladiosimulator.edp2.EDP2Plugin;
import org.palladiosimulator.edp2.impl.RepositoryManager;
import org.palladiosimulator.edp2.models.Repository.Repositories;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.models.Repository.RepositoryFactory;
import org.palladiosimulator.edp2.ui.wizards.datasource.DiscoverLocalDirectoryPage;
import org.palladiosimulator.edp2.ui.wizards.datasource.SelectDataSourceTypePage;

public class OpenDataSourceWizard
extends Wizard {
    private DiscoverLocalDirectoryPage discoverLocalFilePage;
    private SelectDataSourceTypePage selectDataSourceTypePage;

    public void addPages() {
        this.selectDataSourceTypePage = new SelectDataSourceTypePage();
        this.addPage((IWizardPage)this.selectDataSourceTypePage);
        this.discoverLocalFilePage = new DiscoverLocalDirectoryPage();
        this.addPage((IWizardPage)this.discoverLocalFilePage);
    }

    public String getWindowTitle() {
        return "Open EDP2 Data Source";
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.selectDataSourceTypePage) {
            if (this.selectDataSourceTypePage.getSelection().equals("File data source")) {
                return this.discoverLocalFilePage;
            }
            if (this.selectDataSourceTypePage.getSelection().equals("In-Memory data source")) {
                return null;
            }
            assert (false);
        }
        return null;
    }

    public boolean canFinish() {
        return this.selectDataSourceTypePage.isPageComplete() && (this.selectDataSourceTypePage.getSelection().equals("File data source") ? this.discoverLocalFilePage.isPageComplete() : this.selectDataSourceTypePage.getSelection().equals("In-Memory data source"));
    }

    public boolean performFinish() {
        if (this.selectDataSourceTypePage.getSelection().equals("File data source")) {
            RepositoryManager.addRepository((Repositories)EDP2Plugin.INSTANCE.getRepositories(), (Repository)this.discoverLocalFilePage.getRepositoryOnFinish());
        } else if (this.selectDataSourceTypePage.getSelection().equals("In-Memory data source")) {
            RepositoryManager.addRepository((Repositories)EDP2Plugin.INSTANCE.getRepositories(), (Repository)RepositoryFactory.eINSTANCE.createLocalMemoryRepository());
        } else {
            assert (false);
            return false;
        }
        return true;
    }
}

