/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.ui.wizards.datasource;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class SelectDataSourceTypePage
extends WizardPage {
    public static final String IN_MEMORY_DATA_SOURCE = "In-Memory data source";
    public static final String FILE_DATA_SOURCE = "File data source";
    private String selection;

    public SelectDataSourceTypePage() {
        super("wizardPage");
        this.setTitle("Select Type of Data Source");
        this.setDescription("Please select the type of the data source you want to open.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        Label label = new Label(container, 0);
        label.setText("Type of data source: ");
        label.setLayoutData((Object)new GridData(32));
        final Combo selectedDataTypeCombo = new Combo(container, 12);
        selectedDataTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SelectDataSourceTypePage.this.selection = selectedDataTypeCombo.getText();
                SelectDataSourceTypePage.this.setPageComplete(true);
            }
        });
        this.populateComboBox(selectedDataTypeCombo);
        GridLayoutFactory.swtDefaults().numColumns(2).spacing(10, 5).generateLayout(container);
    }

    private void populateComboBox(Combo selectedDataType) {
        selectedDataType.add(IN_MEMORY_DATA_SOURCE);
        selectedDataType.select(0);
        selectedDataType.add(FILE_DATA_SOURCE);
        this.selection = IN_MEMORY_DATA_SOURCE;
    }

    public String getSelection() {
        return this.selection;
    }
}

