/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.ui.views.navigator;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.chaindescription.ChainDescription;
import org.palladiosimulator.edp2.datastream.edp2source.Edp2DataTupleDataSource;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange;
import org.palladiosimulator.edp2.models.ExperimentData.RawMeasurements;
import org.palladiosimulator.edp2.ui.EDP2UIPlugin;
import org.palladiosimulator.edp2.visualization.IVisualisationInput;
import org.palladiosimulator.edp2.visualization.wizards.DefaultViewsWizard;

public class NavigatorDoubleClickListener
implements IDoubleClickListener {
    public void doubleClick(DoubleClickEvent event) {
        Object selectedObject = null;
        if (event.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            selectedObject = selection.getFirstElement();
        }
        if (selectedObject instanceof Measurement) {
            this.openChainSelectionDialog(selectedObject);
        }
    }

    private void openChainSelectionDialog(Object selectedObject) {
        Measurement measurement = (Measurement)selectedObject;
        RawMeasurements rawMeasurements = ((MeasurementRange)measurement.getMeasurementRanges().get(0)).getRawMeasurements();
        if (rawMeasurements != null && !rawMeasurements.getDataSeries().isEmpty()) {
            Edp2DataTupleDataSource edp2Source = new Edp2DataTupleDataSource(rawMeasurements);
            int dataStreamSize = edp2Source.getDataStream().size();
            edp2Source.getDataStream().close();
            if (dataStreamSize > 0) {
                this.openWizard((IDataSource)edp2Source);
            }
        } else {
            throw new RuntimeException("Empty Measurements!");
        }
    }

    private void openWizard(IDataSource edp2Source) {
        DefaultViewsWizard wizard = new DefaultViewsWizard(edp2Source);
        WizardDialog wdialog = new WizardDialog(EDP2UIPlugin.INSTANCE.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        wdialog.open();
        if (wdialog.getReturnCode() == 0) {
            this.openEditor(edp2Source, wizard);
        }
    }

    private void openEditor(IDataSource edp2Source, DefaultViewsWizard wizard) {
        ChainDescription chainDescription = wizard.getSelectedDefault();
        IVisualisationInput input = (IVisualisationInput)chainDescription.getVisualizationInput();
        input.addInput(input.createNewInput(chainDescription.attachRootDataSource(edp2Source)));
        try {
            IWorkbenchPage page = EDP2UIPlugin.INSTANCE.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            page.openEditor((IEditorInput)input, "org.palladiosimulator.edp2.visualization.editors.JFreeChartEditor");
        }
        catch (PartInitException e) {
            throw new RuntimeException(e);
        }
    }
}

