/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.ui.views.navigator;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.RGB;
import org.palladiosimulator.edp2.datastream.edp2source.Edp2DataTupleDataSource;
import org.palladiosimulator.edp2.models.ExperimentData.AggregatedMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroup;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroupRun;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentSetting;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange;
import org.palladiosimulator.edp2.models.ExperimentData.MeasuringType;
import org.palladiosimulator.edp2.models.ExperimentData.RawMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.provider.ExperimentDataItemProviderAdapterFactory;
import org.palladiosimulator.edp2.models.ExperimentData.util.ExperimentDataSwitch;
import org.palladiosimulator.edp2.models.Repository.LocalMemoryRepository;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.models.Repository.provider.RepositoryItemProviderAdapterFactory;
import org.palladiosimulator.edp2.models.Repository.util.RepositorySwitch;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.provider.MeasuringpointItemProviderAdapterFactory;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.metricspec.util.MetricSpecSwitch;

public class NavigatorTreeLabelProviderImpl
extends StyledCellLabelProvider {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String EMPTY_SENSOR_COLOR = "Empty Sensor Color";
    private static final ComposedAdapterFactory COMPOSED_FACTORY = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private static final AdapterFactoryLabelProvider LABEL_PROVIDER;
    private final IMapChangeListener mapChangeListener = new IMapChangeListener(){

        public void handleMapChange(MapChangeEvent event) {
            Set affectedElements = event.diff.getChangedKeys();
            if (!affectedElements.isEmpty()) {
                LabelProviderChangedEvent newEvent = new LabelProviderChangedEvent((IBaseLabelProvider)NavigatorTreeLabelProviderImpl.this, affectedElements.toArray());
                NavigatorTreeLabelProviderImpl.this.fireLabelProviderChanged(newEvent);
            }
        }
    };

    static {
        JFaceResources.getColorRegistry().put(EMPTY_SENSOR_COLOR, new RGB(150, 150, 150));
        COMPOSED_FACTORY.addAdapterFactory((AdapterFactory)new ExperimentDataItemProviderAdapterFactory());
        COMPOSED_FACTORY.addAdapterFactory((AdapterFactory)new MeasuringpointItemProviderAdapterFactory());
        COMPOSED_FACTORY.addAdapterFactory((AdapterFactory)new RepositoryItemProviderAdapterFactory());
        COMPOSED_FACTORY.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        LABEL_PROVIDER = new AdapterFactoryLabelProvider((AdapterFactory)COMPOSED_FACTORY);
    }

    public NavigatorTreeLabelProviderImpl(IObservableMap[] attributeMaps) {
        int i = 0;
        while (i < attributeMaps.length) {
            attributeMaps[i].addMapChangeListener(this.mapChangeListener);
            ++i;
        }
    }

    public String getToolTipText(Object element) {
        EObject eObject;
        StyledString styledString;
        if (element instanceof EObject && (styledString = (StyledString)new ExperimentDataSwitch<StyledString>(){

            public StyledString caseMeasurement(Measurement object) {
                MeasuringType measuringType = object.getMeasuringType();
                MetricDescription metricDescription = measuringType.getMetric();
                return (StyledString)new MetricSpecSwitch<StyledString>(){

                    public final StyledString caseBaseMetricDescription(BaseMetricDescription object) {
                        StyledString styledString = new StyledString(object.getName() == null ? "Base Metric" : object.getName());
                        String decoration = " (" + object.getScale() + ")";
                        styledString.append(decoration, StyledString.COUNTER_STYLER);
                        return styledString;
                    }

                    public final StyledString caseNumericalBaseMetricDescription(NumericalBaseMetricDescription object) {
                        StyledString styledString = new StyledString(object.getName() == null ? "Base Metric" : object.getName());
                        String decoration = " (" + object.getScale() + ", " + object.getDefaultUnit() + ")";
                        styledString.append(decoration, StyledString.COUNTER_STYLER);
                        return styledString;
                    }

                    public StyledString caseMetricSetDescription(MetricSetDescription object) {
                        StyledString styledString = new StyledString("MetricSet [\n");
                        int subsumedMetrics = object.getSubsumedMetrics().size();
                        int i = 0;
                        while (i < subsumedMetrics) {
                            styledString.append("  ");
                            MetricDescription subsumedMetric = (MetricDescription)object.getSubsumedMetrics().get(i);
                            styledString.append((StyledString)this.doSwitch((EObject)subsumedMetric));
                            if (i != subsumedMetrics - 1) {
                                styledString.append(";\n");
                            }
                            ++i;
                        }
                        styledString.append("]\n\nDescription:\n");
                        styledString.append(object.getTextualDescription());
                        return styledString;
                    }

                    public final StyledString caseMetricDescription(MetricDescription object) {
                        StyledString styledString = new StyledString(object.getName() == null ? "Metric Set" : object.getName());
                        return styledString;
                    }
                }.doSwitch((EObject)metricDescription);
            }
        }.doSwitch(eObject = (EObject)element)) != null) {
            return styledString.getString();
        }
        return null;
    }

    public void update(ViewerCell cell) {
        if (cell.getElement() instanceof EObject) {
            EObject eObject = (EObject)cell.getElement();
            StyledString styledString = null;
            styledString = (StyledString)new ExperimentDataSwitch<StyledString>(){

                public StyledString caseExperimentGroup(ExperimentGroup object) {
                    StyledString styledString = new StyledString("Experiment Group ");
                    String decoration = String.valueOf(object.getPurpose()) + " (" + object.getId() + ")";
                    styledString.append(decoration, StyledString.COUNTER_STYLER);
                    return styledString;
                }

                public StyledString caseExperimentSetting(ExperimentSetting object) {
                    StyledString styledString = new StyledString("Experiment Setting ");
                    String decoration = object.getDescription() == null ? "" : object.getDescription();
                    styledString.append(decoration, StyledString.COUNTER_STYLER);
                    return styledString;
                }

                public StyledString caseExperimentRun(ExperimentRun object) {
                    StyledString styledString = new StyledString("Experiment Run " + DATE_FORMAT.format(object.getStartTime()));
                    String decoration = " (" + object.getId() + ")";
                    styledString.append(decoration, StyledString.COUNTER_STYLER);
                    return styledString;
                }

                public StyledString caseExperimentGroupRun(ExperimentGroupRun object) {
                    StyledString styledString = new StyledString("Group Reports " + DATE_FORMAT.format(object.getStartTime()));
                    String decoration = " (" + object.getId() + ")";
                    styledString.append(decoration, StyledString.COUNTER_STYLER);
                    return styledString;
                }

                public StyledString caseMeasurementRange(MeasurementRange object) {
                    StyledString styledString = new StyledString("Range");
                    if (object.getStartTime() != null && object.getEndTime() != null) {
                        String decoration = " (" + object.getStartTime() + "-" + object.getEndTime() + ")";
                        styledString.append(decoration, StyledString.COUNTER_STYLER);
                    }
                    return styledString;
                }

                public StyledString caseRawMeasurements(RawMeasurements object) {
                    StyledString styledString = new StyledString("Raw");
                    String decoration = " (" + object.getDataSeries().size() + ")";
                    styledString.append(decoration, StyledString.COUNTER_STYLER);
                    return styledString;
                }

                public StyledString caseAggregatedMeasurements(AggregatedMeasurements object) {
                    StyledString styledString = new StyledString("Aggregated");
                    return styledString;
                }

                public StyledString caseMeasuringType(MeasuringType object) {
                    MeasuringPoint measuringPoint = object.getMeasuringPoint();
                    StyledString styledString = new StyledString(measuringPoint.getStringRepresentation());
                    String decoration = " (" + object.getMetric().getName() + ")";
                    styledString.append(decoration, StyledString.COUNTER_STYLER);
                    return styledString;
                }

                public StyledString caseMeasurement(Measurement object) {
                    MeasuringType measuringType = object.getMeasuringType();
                    MeasuringPoint measuringPoint = measuringType.getMeasuringPoint();
                    StyledString styledString = new StyledString(measuringPoint.getStringRepresentation());
                    String decoration = " (" + measuringType.getMetric().getName() + ")";
                    styledString.append(decoration, StyledString.COUNTER_STYLER);
                    Edp2DataTupleDataSource dataSource = new Edp2DataTupleDataSource(((MeasurementRange)object.getMeasurementRanges().get(0)).getRawMeasurements());
                    if (dataSource.getDataStream().size() == 0) {
                        styledString.setStyle(0, styledString.length(), StyledString.createColorRegistryStyler((String)NavigatorTreeLabelProviderImpl.EMPTY_SENSOR_COLOR, null));
                    }
                    dataSource.getDataStream().close();
                    return styledString;
                }
            }.doSwitch(eObject);
            if (styledString == null) {
                styledString = (StyledString)new MetricSpecSwitch<StyledString>(){

                    public final StyledString caseBaseMetricDescription(BaseMetricDescription object) {
                        StyledString styledString = new StyledString(object.getName() == null ? "Base Metric" : object.getName());
                        String decoration = " (" + object.getScale() + ")";
                        styledString.append(decoration, StyledString.COUNTER_STYLER);
                        return styledString;
                    }

                    public final StyledString caseNumericalBaseMetricDescription(NumericalBaseMetricDescription object) {
                        StyledString styledString = new StyledString(object.getName() == null ? "Base Metric" : object.getName());
                        String decoration = " (" + object.getScale() + ", " + object.getDefaultUnit() + ")";
                        styledString.append(decoration, StyledString.COUNTER_STYLER);
                        return styledString;
                    }

                    public final StyledString caseMetricDescription(MetricDescription object) {
                        StyledString styledString = new StyledString(object.getName() == null ? "Metric Set" : object.getName());
                        return styledString;
                    }
                }.doSwitch(eObject);
            }
            if (styledString == null) {
                styledString = (StyledString)new RepositorySwitch<StyledString>(){

                    public StyledString caseRepository(Repository object) {
                        StyledString styledString = new StyledString(object.eClass().getName());
                        String decoration = " (" + object.getId() + ")";
                        styledString.append(decoration, StyledString.COUNTER_STYLER);
                        return styledString;
                    }

                    public StyledString caseLocalMemoryRepository(LocalMemoryRepository object) {
                        StyledString styledString = new StyledString("Local Memory");
                        String decoration = " (" + object.getId() + ")";
                        styledString.append(decoration, StyledString.COUNTER_STYLER);
                        return styledString;
                    }
                }.doSwitch(eObject);
            }
            if (styledString == null) {
                Logger.getLogger(NavigatorTreeLabelProviderImpl.class.getCanonicalName()).log(Level.SEVERE, "Could not create label for " + eObject);
            } else {
                cell.setText(styledString.getString());
                cell.setImage(LABEL_PROVIDER.getImage((Object)eObject));
                cell.setStyleRanges(styledString.getStyleRanges());
            }
        }
    }
}

