/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.ui.EDP2UIPlugin;
import org.palladiosimulator.edp2.ui.wizards.BatchFileExportWizard;

public class BatchExportHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)selection;
            if (treeSelection.getFirstElement() instanceof Repository) {
                Repository repo = (Repository)treeSelection.getFirstElement();
                WizardDialog dialog = new WizardDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (IWizard)new BatchFileExportWizard(repo));
                dialog.open();
            } else {
                this.openErrorMesage();
            }
        } else {
            this.openErrorMesage();
        }
        return null;
    }

    private void openErrorMesage() {
        Shell shell = EDP2UIPlugin.INSTANCE.getWorkbench().getActiveWorkbenchWindow().getShell();
        ErrorDialog.openError((Shell)shell, (String)"Select Repository", (String)"Batch Export Failed.", (IStatus)new Status(4, "org.palladiosimulator.edp2.ui", "You need to select a EDP2 Repository to execute the Batch Export Command"));
    }
}

