/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.util.visitors;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentDataFactory;
import org.palladiosimulator.edp2.models.ExperimentData.RawMeasurements;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.CaptureType;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.metricspec.PersistenceKindOptions;
import org.palladiosimulator.metricspec.util.MetricSpecSwitch;

public class DataSeriesFromRawMeasurementsSwitch
extends MetricSpecSwitch<Boolean> {
    private static final Logger LOGGER = Logger.getLogger(DataSeriesFromRawMeasurementsSwitch.class.getCanonicalName());
    private static final ExperimentDataFactory FACTORY = ExperimentDataFactory.eINSTANCE;
    private final RawMeasurements rm;

    public DataSeriesFromRawMeasurementsSwitch(RawMeasurements rm) {
        this.rm = rm;
    }

    public Boolean caseMetricSetDescription(MetricSetDescription object) {
        Iterator iter = object.getSubsumedMetrics().iterator();
        boolean success = true;
        while (iter.hasNext()) {
            success &= ((Boolean)this.doSwitch((EObject)iter.next())).booleanValue();
        }
        return success;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Boolean caseBaseMetricDescription(BaseMetricDescription bmd) {
        String valuesUuid = EcoreUtil.generateUUID();
        if (bmd.getCaptureType() == CaptureType.IDENTIFIER) {
            FACTORY.createIdentifierBasedMeasurements(this.rm, valuesUuid);
            return true;
        }
        if (bmd.getCaptureType() == CaptureType.INTEGER_NUMBER) {
            NumericalBaseMetricDescription nmbd = (NumericalBaseMetricDescription)bmd;
            if (nmbd.getPersistenceKind() == PersistenceKindOptions.BINARY_PREFERRED) {
                FACTORY.createLongBinaryMeasurements(this.rm, valuesUuid, nmbd.getDefaultUnit());
                return true;
            }
            if (nmbd.getPersistenceKind() == PersistenceKindOptions.JS_XML_PREFERRED) {
                FACTORY.createJSXmlMeasurements(this.rm, valuesUuid);
                return true;
            }
            String msg = "PersistenceKindOption of measure not known.";
            LOGGER.log(Level.SEVERE, "PersistenceKindOption of measure not known.");
            throw new IllegalArgumentException("PersistenceKindOption of measure not known.");
        }
        if (bmd.getCaptureType() != CaptureType.REAL_NUMBER) {
            String msg = "CaptureType of measure not known.";
            LOGGER.log(Level.SEVERE, "CaptureType of measure not known.");
            throw new IllegalArgumentException("CaptureType of measure not known.");
        }
        NumericalBaseMetricDescription nmbd = (NumericalBaseMetricDescription)bmd;
        if (nmbd.getPersistenceKind() == PersistenceKindOptions.BINARY_PREFERRED) {
            FACTORY.createDoubleBinaryMeasurements(this.rm, valuesUuid, nmbd.getDefaultUnit());
            return true;
        }
        if (nmbd.getPersistenceKind() == PersistenceKindOptions.JS_XML_PREFERRED) {
            FACTORY.createJSXmlMeasurements(this.rm, valuesUuid);
            return true;
        }
        String msg = "PersistenceKindOption of measure not known.";
        LOGGER.log(Level.SEVERE, "PersistenceKindOption of measure not known.");
        throw new IllegalArgumentException("PersistenceKindOption of measure not known.");
    }
}

