/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.util.visitors;

import javax.measure.quantity.Quantity;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.edp2.dao.BinaryMeasurementsDao;
import org.palladiosimulator.edp2.dao.MeasurementsDaoFactory;
import org.palladiosimulator.edp2.models.ExperimentData.DataSeries;
import org.palladiosimulator.edp2.models.ExperimentData.DoubleBinaryMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentDataFactory;
import org.palladiosimulator.edp2.models.ExperimentData.IdentifierBasedMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.JSXmlMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.LongBinaryMeasurements;
import org.palladiosimulator.edp2.models.ExperimentData.util.ExperimentDataSwitch;
import org.palladiosimulator.edp2.util.MeasurementsUtility;

public class EmfmodelDataSeriesFromReferenceSwitch<Q extends Quantity>
extends ExperimentDataSwitch<DataSeries> {
    private static final ExperimentDataFactory experimentDatafactory = ExperimentDataFactory.eINSTANCE;
    private final MeasurementsDaoFactory daoFactory;
    private final String valuesId = EcoreUtil.generateUUID();

    public EmfmodelDataSeriesFromReferenceSwitch(MeasurementsDaoFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    public DataSeries caseIdentifierBasedMeasurements(IdentifierBasedMeasurements object) {
        IdentifierBasedMeasurements ibm = experimentDatafactory.createIdentifierBasedMeasurements();
        this.daoFactory.createNominalMeasurementsDao(this.valuesId, MeasurementsUtility.getTextualBaseMetricDescriptionFromIdentifierMeasurement(object));
        ibm.setValuesUuid(this.valuesId);
        return ibm;
    }

    public DataSeries caseJSXmlMeasurements(JSXmlMeasurements object) {
        JSXmlMeasurements jsxml = experimentDatafactory.createJSXmlMeasurements();
        this.daoFactory.createJScienceXmlMeasurementsDao(this.valuesId);
        jsxml.setValuesUuid(this.valuesId);
        return jsxml;
    }

    public DataSeries caseDoubleBinaryMeasurements(DoubleBinaryMeasurements object) {
        DoubleBinaryMeasurements dbm = experimentDatafactory.createDoubleBinaryMeasurements();
        dbm.setValuesUuid(this.valuesId);
        dbm.setStorageUnit(object.getStorageUnit());
        BinaryMeasurementsDao bmdao = this.daoFactory.createDoubleMeasurementsDao(this.valuesId);
        bmdao.setUnit(dbm.getStorageUnit());
        return dbm;
    }

    public DataSeries caseLongBinaryMeasurements(LongBinaryMeasurements object) {
        LongBinaryMeasurements lbm = experimentDatafactory.createLongBinaryMeasurements();
        lbm.setValuesUuid(this.valuesId);
        lbm.setStorageUnit(object.getStorageUnit());
        BinaryMeasurementsDao bmdao = this.daoFactory.createLongMeasurementsDao(this.valuesId);
        bmdao.setUnit(lbm.getStorageUnit());
        return lbm;
    }
}

