/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.visualization.jfreechart.input;

import java.util.HashMap;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.edp2.visualization.AbstractVisualizationSingleDatastreamInput;
import org.palladiosimulator.edp2.visualization.jfreechart.input.JFreeChartVisualizationInput;
import org.palladiosimulator.edp2.visualization.jfreechart.input.JFreeChartVisualizationSingleDatastreamInput;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

public abstract class AbstractXYVisualizationInput
extends JFreeChartVisualizationInput {
    private int xPos;

    protected void firstChildInputAdded(JFreeChartVisualizationSingleDatastreamInput newChildInput) {
        super.firstChildInputAdded((AbstractVisualizationSingleDatastreamInput)newChildInput);
        HashMap<String, String> configuration = new HashMap<String, String>(this.getConfiguration().getProperties());
        configuration.put("domainAxisLabel", this.getAxisDefaultLabel(this.getXPos()));
        configuration.put("rangeAxisLabel", this.getAxisDefaultLabel(this.getYPos()));
        this.getConfiguration().setProperties(configuration);
    }

    public boolean canAccept(IDataSource source) {
        BaseMetricDescription[] mds = MetricDescriptionUtility.toBaseMetricDescriptions((MetricDescription)source.getMetricDesciption());
        if (mds.length != 2) {
            return false;
        }
        BaseMetricDescription[] baseMetricDescriptionArray = mds;
        int n = mds.length;
        int n2 = 0;
        while (n2 < n) {
            BaseMetricDescription md = baseMetricDescriptionArray[n2];
            if (!(md instanceof NumericalBaseMetricDescription)) {
                return false;
            }
            ++n2;
        }
        this.xPos = 0;
        if (mds[1].getId().equals(MetricDescriptionConstants.POINT_IN_TIME_METRIC.getId())) {
            this.xPos = 1;
        }
        return true;
    }

    protected int getXPos() {
        return this.xPos;
    }

    protected int getYPos() {
        return 1 - this.xPos;
    }
}

