/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.visualization.jfreechart.input.cdf;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.measure.Measure;
import org.eclipse.ui.IMemento;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.palladiosimulator.edp2.datastream.AbstractDataSource;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.datastream.configurable.PropertyConfigurable;
import org.palladiosimulator.edp2.visualization.jfreechart.input.AbstractXYVisualizationInput;
import org.palladiosimulator.edp2.visualization.jfreechart.input.JFreeChartVisualizationSingleDatastreamInput;
import org.palladiosimulator.edp2.visualization.jfreechart.input.cdf.CDFVisualizationInputConfiguration;
import org.palladiosimulator.edp2.visualization.jfreechart.input.cdf.CDFVisualizationInputFactory;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;

public class CDFVisualizationInput
extends AbstractXYVisualizationInput {
    public CDFVisualizationInput() {
        this((AbstractDataSource)null);
    }

    public CDFVisualizationInput(AbstractDataSource source) {
    }

    public String getFactoryId() {
        return CDFVisualizationInputFactory.FACTORY_ID;
    }

    @Override
    public void saveState(IMemento memento) {
        CDFVisualizationInputFactory.saveState(memento, this);
    }

    @Override
    protected Plot generatePlot(PropertyConfigurable config, AbstractDataset dataset) {
        CDFVisualizationInputConfiguration configuration = (CDFVisualizationInputConfiguration)config;
        XYPlot plot = new XYPlot();
        XYDataset xyDataset = (XYDataset)dataset;
        NumberAxis domainAxis = new NumberAxis(configuration.isShowDomainAxisLabel() ? configuration.getDomainAxisLabel() : null);
        NumberAxis rangeAxis = new NumberAxis(configuration.isShowRangeAxisLabel() ? configuration.getRangeAxisLabel() : null);
        plot.setRangeAxis((ValueAxis)rangeAxis);
        plot.setDomainAxis((ValueAxis)domainAxis);
        plot.setDataset(xyDataset);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        boolean isShowSeriesLine = configuration.isShowSeriesLine();
        boolean isShowSeriesShape = configuration.isShowSeriesShapes();
        int i = 0;
        while (i < xyDataset.getSeriesCount()) {
            renderer.setSeriesLinesVisible(i, isShowSeriesLine);
            renderer.setSeriesShapesVisible(i, isShowSeriesShape);
            ++i;
        }
        plot.setRenderer((XYItemRenderer)renderer);
        this.configureSeriesColors((AbstractRenderer)renderer);
        return plot;
    }

    @Override
    protected AbstractDataset generateDataset() {
        DefaultXYDataset dataset = new DefaultXYDataset();
        int i = 1;
        for (JFreeChartVisualizationSingleDatastreamInput childInput : this.getInputs()) {
            dataset.addSeries((Comparable)((Object)(String.valueOf(i) + ": " + childInput.getInputName())), this.computeCDFData(childInput));
            ++i;
        }
        return dataset;
    }

    @Override
    protected PropertyConfigurable createConfiguration() {
        return new CDFVisualizationInputConfiguration();
    }

    @Override
    protected void firstChildInputAdded(JFreeChartVisualizationSingleDatastreamInput newChildInput) {
        super.firstChildInputAdded(newChildInput);
        HashMap<String, Object> properties = new HashMap<String, Object>(this.getProperties());
        MetricSetDescription metricSet = (MetricSetDescription)newChildInput.getDataSource().getMetricDesciption();
        NumericalBaseMetricDescription baseMetric = (NumericalBaseMetricDescription)metricSet.getSubsumedMetrics().get(this.getYPos());
        properties.put("unit", baseMetric.getDefaultUnit());
        properties.put("domainAxisLabel", this.getAxisDefaultLabel(this.getYPos()));
        properties.put("rangeAxisLabel", "Summed Probability [%]");
        this.setProperties(properties);
    }

    protected Set<String> getPropertyKeysTriggeringUpdate() {
        return Collections.emptySet();
    }

    private double[][] computeCDFData(JFreeChartVisualizationSingleDatastreamInput childInput) {
        double[] rawValues = this.generateData(childInput.getDataSource());
        Arrays.sort(rawValues);
        double[][] plotData = new double[2][rawValues.length];
        double sum = 0.0;
        int j = 0;
        while (j < rawValues.length) {
            plotData[0][j] = rawValues[j];
            plotData[1][j] = sum;
            sum += 1.0 / (double)rawValues.length;
            ++j;
        }
        return plotData;
    }

    private double[] generateData(IDataSource dataSource) {
        IDataStream inputStream = dataSource.getDataStream();
        double[] data = new double[inputStream.size()];
        CDFVisualizationInputConfiguration configuration = (CDFVisualizationInputConfiguration)this.getConfiguration();
        int i = 0;
        for (TupleMeasurement tuple : inputStream) {
            Measure measure = tuple.asArray()[this.getYPos()];
            data[i] = measure.doubleValue(configuration.getUnit());
            ++i;
        }
        return data;
    }
}

