/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.visualization.datasource;

import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.edp2source.Edp2DataTupleDataSource;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange;
import org.palladiosimulator.edp2.models.ExperimentData.RawMeasurements;
import org.palladiosimulator.edp2.visualization.IVisualisationInput;
import org.palladiosimulator.edp2.visualization.IVisualisationSingleDatastreamInput;

public class DatasourceDropTargetAdapter<T extends IVisualisationSingleDatastreamInput>
extends DropTargetAdapter {
    private final IVisualisationInput<T> visualizationInput;

    public DatasourceDropTargetAdapter(IVisualisationInput<T> iVisualisationInput) {
        this.visualizationInput = iVisualisationInput;
    }

    public void drop(DropTargetEvent event) {
        IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
        if (selection.getFirstElement() instanceof Measurement) {
            Measurement measurement = (Measurement)selection.getFirstElement();
            RawMeasurements rawMeasurements = ((MeasurementRange)measurement.getMeasurementRanges().get(0)).getRawMeasurements();
            Edp2DataTupleDataSource newSource = new Edp2DataTupleDataSource(rawMeasurements);
            T newInput = this.visualizationInput.createNewInput((IDataSource)newSource);
            this.visualizationInput.addInput(newInput);
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        event.detail = 4;
    }

    public void dragEnter(DropTargetEvent event) {
        event.detail = 4;
    }
}

