/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.visualization.properties.sections;

import de.uka.ipd.sdq.dialogs.selection.FilteredItemsAdapterFactory;
import de.uka.ipd.sdq.dialogs.selection.SelectEObjectDialog;
import java.awt.Color;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.measure.Measure;
import javax.measure.MeasureFormat;
import javax.measure.unit.UnitFormat;
import org.apache.commons.lang.ClassUtils;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.edp2.datastream.configurable.IPropertyConfigurable;
import org.palladiosimulator.edp2.visualization.properties.sections.EMFAdapterFactoryHelper;

public class EDP2PropertiesTable {
    private static int editColumn = 1;
    private static int labelColumn = 0;
    private static final ArrayList<Object> FILTER_LIST = new ArrayList();
    private static final ArrayList<EReference> ADDITIONAL_REFERENCES = new ArrayList();
    private final Table myTable;
    private static final String MEASURE_PARSE_ERROR_MESSAGE = "The given input could not be recognized as a valid measurement.\nRequired is a value follwed by a unit!\n\nDetailed error message:\n %s";
    private static final Locale NUMBER_FORMAT_LOCALE;
    private final MeasureFormat measureFormat;
    private IPropertyConfigurable lastSelectedInput;

    static {
        FILTER_LIST.add(EObject.class);
        NUMBER_FORMAT_LOCALE = Locale.ENGLISH;
    }

    public EDP2PropertiesTable(Composite parent) {
        this.myTable = new Table(parent, 68100);
        this.initializeTable();
        this.measureFormat = this.initializeMeasureFormat();
    }

    private MeasureFormat initializeMeasureFormat() {
        NumberFormat numberFormat = NumberFormat.getInstance(NUMBER_FORMAT_LOCALE);
        numberFormat.setMinimumFractionDigits(1);
        return MeasureFormat.getInstance((NumberFormat)numberFormat, (UnitFormat)UnitFormat.getInstance());
    }

    private void initializeTable() {
        this.myTable.setLinesVisible(true);
        this.myTable.setHeaderVisible(true);
        GridData gridData = new GridData(4, 4, false, true, 1, 1);
        gridData.heightHint = 250;
        gridData.widthHint = 250;
        this.myTable.setLayoutData((Object)gridData);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2));
        this.myTable.setLayout((Layout)tableLayout);
        TableViewer commonPropertiesTableViewer = new TableViewer(this.myTable);
        TableViewerColumn keyColumn = new TableViewerColumn(commonPropertiesTableViewer, 0);
        keyColumn.getColumn().setText("Property");
        TableViewerColumn valueColumn = new TableViewerColumn(commonPropertiesTableViewer, 0);
        valueColumn.getColumn().setText("Value");
        this.myTable.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = EDP2PropertiesTable.this.myTable.getClientArea();
                Point pt = new Point(event.x, event.y);
                int index = EDP2PropertiesTable.this.myTable.getTopIndex();
                while (index < EDP2PropertiesTable.this.myTable.getItemCount()) {
                    boolean visible = false;
                    TableItem item = EDP2PropertiesTable.this.myTable.getItem(index);
                    Rectangle rect = item.getBounds(editColumn);
                    if (rect.contains(pt)) {
                        Class propertyType = EDP2PropertiesTable.this.lastSelectedInput.getPropertyType(item.getText(labelColumn));
                        if (ClassUtils.isAssignable((Class)propertyType, Boolean.class, (boolean)true)) {
                            EDP2PropertiesTable.this.openBooleanDialog(index, EDP2PropertiesTable.this.myTable);
                        } else if (ClassUtils.isAssignable((Class)propertyType, String.class, (boolean)true)) {
                            EDP2PropertiesTable.this.openTextDialog(index, EDP2PropertiesTable.this.myTable, String.class);
                        } else if (ClassUtils.isAssignable((Class)propertyType, Integer.class, (boolean)true)) {
                            EDP2PropertiesTable.this.openTextDialog(index, EDP2PropertiesTable.this.myTable, Integer.class);
                        } else if (ClassUtils.isAssignable((Class)propertyType, Float.class, (boolean)true)) {
                            EDP2PropertiesTable.this.openTextDialog(index, EDP2PropertiesTable.this.myTable, Float.class);
                        } else if (ClassUtils.isAssignable((Class)propertyType, Double.class, (boolean)true)) {
                            EDP2PropertiesTable.this.openTextDialog(index, EDP2PropertiesTable.this.myTable, Double.class);
                        } else if (ClassUtils.isAssignable((Class)propertyType, Color.class, (boolean)true)) {
                            EDP2PropertiesTable.this.openColorAndTransparencyDialog(item, EDP2PropertiesTable.this.myTable);
                        } else if (ClassUtils.isAssignable((Class)propertyType, EObject.class, (boolean)true)) {
                            EDP2PropertiesTable.this.openEObjectDialog(item, EDP2PropertiesTable.this.myTable, propertyType, FILTER_LIST, ADDITIONAL_REFERENCES);
                        } else if (ClassUtils.isAssignable(Measure.class, (Class)propertyType, (boolean)true)) {
                            EDP2PropertiesTable.this.openMeasureDialog(index, EDP2PropertiesTable.this.myTable);
                        } else {
                            return;
                        }
                        return;
                    }
                    if (!visible && rect.intersects(clientArea)) {
                        visible = true;
                    }
                    if (!visible) {
                        return;
                    }
                    ++index;
                }
            }
        });
    }

    protected void openColorAndTransparencyDialog(TableItem item, Table table) {
        ColorDialog colorPicker = new ColorDialog(table.getShell());
        colorPicker.setRGB(item.getBackground().getRGB());
        RGB rgbColor = colorPicker.open();
        if (rgbColor != null) {
            Color newColor = new Color(rgbColor.red, rgbColor.green, rgbColor.blue);
            this.updateColorCell(item, newColor);
            this.updateProperties(item.getText(labelColumn), newColor, table);
        }
    }

    protected void openEObjectDialog(TableItem item, Table table, Class<?> propertyType, Collection<?> filterList, Collection<EReference> additionalChildReferences) {
        SelectEObjectDialog selectEObjectDialog = new SelectEObjectDialog(table.getShell(), propertyType.getSimpleName(), (Object)new ResourceSetImpl(), new AdapterFactoryContentProvider((AdapterFactory)new FilteredItemsAdapterFactory(EMFAdapterFactoryHelper.ADAPTER_FACTORY, filterList, additionalChildReferences)), (IBaseLabelProvider)EMFAdapterFactoryHelper.ADAPTER_FACTORY_LABEL_PROVIDER);
        selectEObjectDialog.setProvidedService(EObject.class);
        selectEObjectDialog.open();
        if (selectEObjectDialog.getResult() != null) {
            EObject eObject = selectEObjectDialog.getResult();
            this.updateProperties(item.getText(labelColumn), eObject, table);
        }
    }

    private void updateColorCell(TableItem item, Color col) {
        if (col.getAlpha() == 0) {
            item.setText(1, "(default Color)");
        } else {
            item.setText(1, "");
            item.setBackground(1, new org.eclipse.swt.graphics.Color((Device)this.myTable.getDisplay(), col.getRed(), col.getGreen(), col.getBlue()));
        }
    }

    protected void openMeasureDialog(final int index, final Table table) {
        TableEditor editor = new TableEditor(table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        final Text text = new Text((Composite)table, 0);
        Listener textListener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 16: {
                        text.dispose();
                        e.doit = false;
                        break;
                    }
                    case 31: {
                        switch (e.detail) {
                            case 4: {
                                this.handleTraverseReturn();
                            }
                            case 2: {
                                text.dispose();
                                e.doit = false;
                            }
                        }
                    }
                }
            }

            private void handleTraverseReturn() {
                String input = text.getText();
                Measure result = null;
                try {
                    result = (Measure)EDP2PropertiesTable.this.measureFormat.parseObject(input);
                }
                catch (ParseException e) {
                    this.showErrorDialog(e);
                }
                if (result != null) {
                    EDP2PropertiesTable.this.updateProperties(table.getItem(index).getText(labelColumn), result, table);
                    EDP2PropertiesTable.this.refreshTable();
                }
            }

            private void showErrorDialog(Exception e) {
                MessageBox errorDialog = new MessageBox(table.getShell(), 33);
                errorDialog.setText("Error");
                errorDialog.setMessage(String.format(EDP2PropertiesTable.MEASURE_PARSE_ERROR_MESSAGE, e.getMessage()));
                errorDialog.open();
            }
        };
        text.addListener(16, textListener);
        text.addListener(31, textListener);
        editor.setEditor((Control)text, table.getItem(index), editColumn);
        text.setText(table.getItem(index).getText(editColumn));
        text.selectAll();
        text.setFocus();
    }

    protected void openTextDialog(final int index, final Table table, final Class<?> clazz) {
        TableEditor editor = new TableEditor(table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        final Text text = new Text((Composite)table, 0);
        Listener textListener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 16: {
                        text.dispose();
                        e.doit = false;
                        break;
                    }
                    case 31: {
                        switch (e.detail) {
                            case 4: {
                                table.getItem(index).setText(editColumn, text.getText());
                                Object resultValue = null;
                                if (clazz == Float.class) {
                                    resultValue = Float.valueOf(Float.parseFloat(text.getText()));
                                } else if (clazz == Double.class) {
                                    resultValue = Double.parseDouble(text.getText());
                                } else if (clazz == Long.class) {
                                    resultValue = Long.parseLong(text.getText());
                                } else if (clazz == Integer.class) {
                                    resultValue = Integer.parseInt(text.getText());
                                } else if (clazz == String.class) {
                                    resultValue = text.getText();
                                }
                                EDP2PropertiesTable.this.updateProperties(table.getItem(index).getText(labelColumn), resultValue, table);
                                EDP2PropertiesTable.this.refreshTable();
                            }
                            case 2: {
                                text.dispose();
                                e.doit = false;
                            }
                        }
                    }
                }
            }
        };
        text.addListener(16, textListener);
        text.addListener(31, textListener);
        editor.setEditor((Control)text, table.getItem(index), editColumn);
        text.setText(table.getItem(index).getText(editColumn));
        text.selectAll();
        text.setFocus();
    }

    protected void openBooleanDialog(final int index, final Table table) {
        TableEditor editor = new TableEditor(table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        final Combo comboBox = new Combo((Composite)table, 4);
        comboBox.setItems(new String[]{"true", "false"});
        comboBox.select(table.getItem(index).getText(editColumn).equals("true") ? 0 : 1);
        final String key = table.getItem(index).getText(labelColumn);
        comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                table.getItem(index).setText(editColumn, comboBox.getItem(comboBox.getSelectionIndex()));
                EDP2PropertiesTable.this.updateProperties(key, "true".equals(comboBox.getItem(comboBox.getSelectionIndex())), table);
                comboBox.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                comboBox.dispose();
            }
        });
        comboBox.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                comboBox.dispose();
                event.doit = false;
            }
        });
        editor.setEditor((Control)comboBox, table.getItem(index), editColumn);
    }

    private void updateProperties(String key, Object value, Table table) {
        HashMap<String, Object> newProperties = new HashMap<String, Object>(this.lastSelectedInput.getProperties());
        newProperties.put(key, value);
        this.lastSelectedInput.setProperties(newProperties);
        this.refreshTable();
    }

    public void refreshTable() {
        this.myTable.clearAll();
        this.myTable.setItemCount(0);
        if (this.lastSelectedInput != null) {
            Map properties = this.lastSelectedInput.getProperties();
            for (String key : properties.keySet()) {
                TableItem item = new TableItem(this.myTable, 0);
                item.setText(0, String.valueOf(key));
                if (this.lastSelectedInput.isPropertyNotSet(key)) {
                    item.setText(1, "<not set>");
                    continue;
                }
                this.prettyPrintProperty(item, properties.get(key));
            }
        }
    }

    private void prettyPrintProperty(TableItem item, Object value) {
        Class<?> propertyType = value.getClass();
        if (ClassUtils.isAssignable(propertyType, Color.class)) {
            Color col = (Color)value;
            this.updateColorCell(item, col);
        } else if (ClassUtils.isAssignable(propertyType, EObject.class)) {
            String displayString = EMFAdapterFactoryHelper.ADAPTER_FACTORY_LABEL_PROVIDER.getText(value);
            item.setText(1, displayString);
        } else if (ClassUtils.isAssignable(propertyType, Measure.class)) {
            item.setText(1, this.measureFormat.format(value));
        } else {
            item.setText(1, String.valueOf(value));
        }
    }

    public void setLastSelection(IPropertyConfigurable iPropertyConfigurable) {
        this.lastSelectedInput = iPropertyConfigurable;
        this.refreshTable();
    }
}

