/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.visualization.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.palladiosimulator.edp2.datastream.AbstractDataSource;
import org.palladiosimulator.edp2.datastream.filter.AbstractAdapter;
import org.palladiosimulator.edp2.visualization.wizards.AdapterWizard;
import org.palladiosimulator.edp2.visualization.wizards.IAdapterWizard;

public class SelectAdapterPage
extends WizardPage
implements ISelectionChangedListener {
    private static final Logger LOGGER = Logger.getLogger(SelectAdapterPage.class.getCanonicalName());
    private static final String ADAPTER_EXTENSION_POINT_ID = "org.palladiosimulator.edp2.visualization.adapter";
    private static final String ADAPTER_CLASS_ATTRIBUTE = "class";
    private static final String ADAPTER_WIZARD_ATTRIBUTE = "wizard";
    private AbstractDataSource selectedSource;
    private IStatus selectionStatus;
    private final Status statusOK;
    private IAdapterWizard selectedAdapterWizard;

    protected SelectAdapterPage(String pageName, AbstractDataSource selectedSource) {
        super(pageName);
        this.selectedSource = selectedSource;
        this.setDescription("Select the Adapter you wish to add.");
        this.statusOK = new Status(0, "not_used", 0, "", null);
        this.selectionStatus = this.statusOK;
    }

    public boolean canFlipToNextPage() {
        return this.updatePageStatus().isOK() && this.selectedAdapterWizard != null;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        composite.setLayout((Layout)gl);
        Label label = new Label(composite, 0);
        label.setText("Available Adapters:");
        SashForm sashForm = new SashForm(composite, 256);
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        sashForm.setLayoutData((Object)gd);
        this.initializeAdapterTableViewer(sashForm);
        this.setControl((Control)composite);
        this.updatePageStatus();
    }

    private void initializeAdapterTableViewer(SashForm sashForm) {
        TableViewer adapterViewer = new TableViewer((Composite)sashForm, 2048);
        adapterViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return SelectAdapterPage.this.getApplicableAdapters(SelectAdapterPage.this.selectedSource).toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        adapterViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element != null) {
                    return ((IWizard)element).getWindowTitle();
                }
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        adapterViewer.setInput(this.getApplicableAdapters(this.selectedSource));
        adapterViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected List<IAdapterWizard> getApplicableAdapters(AbstractDataSource forSource) {
        IConfigurationElement[] adapterExtensions;
        ArrayList<IAdapterWizard> availableAdapters = new ArrayList<IAdapterWizard>();
        IConfigurationElement[] iConfigurationElementArray = adapterExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(ADAPTER_EXTENSION_POINT_ID);
        int n = adapterExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            Object o = null;
            try {
                Object w = e.createExecutableExtension(ADAPTER_WIZARD_ATTRIBUTE);
                o = e.createExecutableExtension(ADAPTER_CLASS_ATTRIBUTE);
                if (((AbstractAdapter)o).getDataSource().isCompatibleWith(forSource.getMetricDesciption())) {
                    availableAdapters.add((IAdapterWizard)w);
                }
            }
            catch (CoreException ex) {
                LOGGER.log(Level.SEVERE, "Error in creating an Object referenced in an extension.");
                throw new RuntimeException();
            }
            LOGGER.log(Level.INFO, o.toString());
            ++n2;
        }
        return availableAdapters;
    }

    public IWizardPage getNextPage() {
        IWizardPage nextPage = null;
        if (this.selectedAdapterWizard != null) {
            this.selectedAdapterWizard.setSourceFromCaller(this.selectedSource, this);
            this.selectedAdapterWizard.addPages();
            nextPage = this.selectedAdapterWizard.getStartingPage();
        }
        return nextPage;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionStatus = this.statusOK;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.selectedAdapterWizard = null;
        if (selection == null) {
            this.selectionStatus = new Status(4, "", 0, "Must select an adapter to proceed.", null);
        } else {
            this.selectedAdapterWizard = (IAdapterWizard)selection.getFirstElement();
            LOGGER.log(Level.INFO, this.selectedAdapterWizard.getWindowTitle());
        }
        this.updatePageStatus();
        this.getContainer().updateButtons();
    }

    public IStatus updatePageStatus() {
        Status pageStatus = this.statusOK;
        switch (this.selectionStatus.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage());
                pageStatus = this.statusOK;
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage(), 2);
                pageStatus = this.selectionStatus;
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage(), 1);
                pageStatus = this.selectionStatus;
                break;
            }
            default: {
                this.setErrorMessage(this.selectionStatus.getMessage());
                this.setMessage(null);
                pageStatus = this.selectionStatus;
            }
        }
        return pageStatus;
    }

    public void setAdapter(AbstractAdapter adapter) {
        LOGGER.log(Level.INFO, "adapter of AdapterWizard set");
        AdapterWizard wizard = (AdapterWizard)this.getWizard();
        wizard.setAdapter(adapter);
    }
}

