/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.visualization;

import java.util.Map;
import java.util.Set;
import org.palladiosimulator.commons.designpatterns.AbstractObservable;
import org.palladiosimulator.edp2.datastream.configurable.IPropertyConfigurable;
import org.palladiosimulator.edp2.datastream.configurable.IPropertyListener;
import org.palladiosimulator.edp2.datastream.configurable.PropertyConfigurable;
import org.palladiosimulator.edp2.visualization.IVisualisationInputListener;

public abstract class AbstractInput
extends AbstractObservable<IVisualisationInputListener>
implements IPropertyConfigurable {
    private final PropertyConfigurable myProperties = this.createConfiguration();

    public AbstractInput() {
        this.myProperties.addObserver((Object)new IPropertyListener(){
            boolean requiresUpdate = false;

            public void propertyChanged(String key, Object oldValue, Object newValue) {
                this.requiresUpdate |= AbstractInput.this.getPropertyKeysTriggeringUpdate().contains(key);
            }

            public void propertyChangeCompleted() {
                ((IVisualisationInputListener)AbstractInput.this.getEventDispatcher()).visualisationInputChanged(this.requiresUpdate);
                this.requiresUpdate = false;
            }
        });
    }

    protected abstract PropertyConfigurable createConfiguration();

    public <G extends IPropertyConfigurable> G getConfiguration() {
        return (G)this.myProperties;
    }

    public Set<String> getKeys() {
        return this.myProperties.getKeys();
    }

    public Map<String, Object> getProperties() {
        return this.myProperties.getProperties();
    }

    public void setProperties(Map<String, Object> properties) {
        this.myProperties.setProperties(properties);
    }

    public Map<? extends String, ? extends Object> getDefaultConfiguration() {
        return this.myProperties.getDefaultConfiguration();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance((Object)this)) {
            return this;
        }
        return null;
    }

    protected abstract Set<String> getPropertyKeysTriggeringUpdate();

    public Class<?> getPropertyType(String key) {
        return this.myProperties.getPropertyType(key);
    }

    public boolean isPropertyNotSet(String key) {
        return this.myProperties.isPropertyNotSet(key);
    }

    public void unsetProperty(String key) {
        this.myProperties.unsetProperty(key);
    }
}

