/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.edp2.dao.exception.DataNotAccessibleException;
import org.palladiosimulator.edp2.models.Repository.Repositories;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.models.Repository.RepositoryFactory;

public class RepositoryManager {
    private static final Logger LOGGER = Logger.getLogger(RepositoryManager.class.getCanonicalName());
    private static Repositories centralRepository = RepositoryFactory.eINSTANCE.createRepositories();

    public static void addRepository(Repositories repos, Repository newRepo) {
        repos.getAvailableRepositories().add((Object)newRepo);
        if (newRepo.canOpen()) {
            try {
                newRepo.open();
            }
            catch (DataNotAccessibleException e) {
                LOGGER.log(Level.WARNING, "Could not open repository after adding it to repositories.", e);
            }
        }
    }

    public static void removeRepository(Repositories repos, Repository repo) {
        assert (repos.getAvailableRepositories().indexOf((Object)repo) > -1);
        if (repo.canClose()) {
            try {
                repo.close();
            }
            catch (DataNotAccessibleException e) {
                LOGGER.log(Level.WARNING, "Could not close repository before removing it from the list.", e);
            }
        }
        repos.getAvailableRepositories().remove((Object)repo);
        LOGGER.log(Level.INFO, "Repository is removed.");
    }

    public static void clearRepositories(Repositories repos) {
        EList<Repository> availableRepositories = repos.getAvailableRepositories();
        try {
            for (Repository repository : availableRepositories) {
                if (!repository.canClose()) continue;
                try {
                    repository.close();
                }
                catch (DataNotAccessibleException e) {
                    LOGGER.log(Level.WARNING, "Could not close repository before removing it from the list.", e);
                }
            }
        }
        finally {
            availableRepositories.clear();
        }
    }

    public static Repositories getCentralRepository() {
        return centralRepository;
    }

    public static Repository getRepositoryFromUUID(String uuid) {
        for (Repository repository : centralRepository.getAvailableRepositories()) {
            if (!repository.getId().equals(uuid)) continue;
            return repository;
        }
        return null;
    }
}

