/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.visualization;

import java.util.HashMap;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.IDataSourceListener;
import org.palladiosimulator.edp2.visualization.AbstractInput;
import org.palladiosimulator.edp2.visualization.AbstractVisualizationInput;
import org.palladiosimulator.edp2.visualization.IVisualisationInputListener;
import org.palladiosimulator.edp2.visualization.IVisualisationSingleDatastreamInput;

public abstract class AbstractVisualizationSingleDatastreamInput
extends AbstractInput
implements IVisualisationSingleDatastreamInput {
    private IDataSource source;
    private AbstractVisualizationInput<? extends AbstractVisualizationSingleDatastreamInput> parentInput;

    public AbstractVisualizationSingleDatastreamInput() {
        this(null);
    }

    public AbstractVisualizationSingleDatastreamInput(IDataSource source) {
        if (source != null) {
            this.setDataSource(source);
        }
    }

    public IDataSource getDataSource() {
        return this.source;
    }

    public void setDataSource(IDataSource source) {
        this.source = source;
        HashMap<String, String> properties = new HashMap<String, String>(this.getConfiguration().getProperties());
        properties.put("inputName", this.getDefaultName());
        this.getConfiguration().setProperties(properties);
        this.source.addObserver((Object)new IDataSourceListener(){

            public void datasourceUpdated() {
                ((IVisualisationInputListener)AbstractVisualizationSingleDatastreamInput.this.getEventDispatcher()).visualisationInputChanged(true);
            }
        });
    }

    private String getDefaultName() {
        if (this.getDataSource() != null) {
            return this.source.getMeasuringPoint().getStringRepresentation();
        }
        return "noSourceSet";
    }

    <T extends AbstractVisualizationSingleDatastreamInput> void setParentInput(AbstractVisualizationInput<T> parent) {
        this.parentInput = parent;
    }

    boolean hasParent() {
        return this.parentInput != null;
    }

    <T extends AbstractVisualizationSingleDatastreamInput> AbstractVisualizationInput<T> getParent() {
        if (this.parentInput == null) {
            throw new IllegalStateException("No Handle set for this JFreeChartEditorInput!");
        }
        return this.parentInput;
    }

    public boolean canAccept(IDataSource dataSource) {
        return this.getParent().canAccept(dataSource);
    }
}

