/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.dao.impl;

import org.palladiosimulator.edp2.dao.Edp2Dao;
import org.palladiosimulator.edp2.dao.exception.DataNotAccessibleException;

public abstract class Edp2DaoImpl
implements Edp2Dao {
    private boolean open = false;
    private boolean deleted = false;

    @Override
    public synchronized void open() throws DataNotAccessibleException {
        if (this.isDeleted()) {
            throw new IllegalStateException("Data has already been deleted.");
        }
        if (this.isOpen()) {
            throw new IllegalStateException("DAO has already been opened.");
        }
    }

    @Override
    public synchronized void close() throws DataNotAccessibleException {
        if (!this.isOpen()) {
            throw new IllegalStateException("State must be open to be changed by close().");
        }
    }

    @Override
    public synchronized void delete() throws DataNotAccessibleException {
        if (this.isOpen()) {
            throw new IllegalStateException("Data cannot be deleted if the status is open.");
        }
        if (this.isDeleted()) {
            throw new IllegalStateException("Data can only be deleted once.");
        }
    }

    @Override
    public synchronized boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public synchronized boolean isOpen() {
        return this.open;
    }

    @Override
    public synchronized boolean canClose() {
        return this.open && !this.deleted;
    }

    @Override
    public synchronized boolean canDelete() {
        return !this.deleted && !this.open;
    }

    @Override
    public boolean canOpen() {
        return !this.open && !this.deleted;
    }

    protected void setOpen() {
        this.open = true;
    }

    protected void setClosed() {
        this.open = false;
    }

    protected void setDeleted(boolean newValue) {
        this.deleted = newValue;
    }
}

