/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.example;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.edp2.dao.exception.DataNotAccessibleException;
import org.palladiosimulator.edp2.example.PieChartExampleData;
import org.palladiosimulator.edp2.impl.RepositoryManager;
import org.palladiosimulator.edp2.local.LocalDirectoryRepository;
import org.palladiosimulator.edp2.models.Repository.Repositories;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.repository.local.LocalDirectoryRepositoryHelper;
import org.palladiosimulator.edp2.util.MeasurementsUtility;
import org.palladiosimulator.metricspec.Description;

public class PieChartStoreExample {
    public static final String DEFAULT_DIRECTORY = "LocalRepository";
    private static final Logger LOGGER = Logger.getLogger(PieChartStoreExample.class.getCanonicalName());
    private final Repository ldRepo;
    private final PieChartExampleData exampleData;

    public PieChartStoreExample() {
        this(DEFAULT_DIRECTORY);
    }

    public PieChartStoreExample(String directory) {
        this.ldRepo = this.initializeRepository(directory);
        this.exampleData = new PieChartExampleData();
    }

    private Repository initializeRepository(String directory) {
        LocalDirectoryRepository repo = LocalDirectoryRepositoryHelper.initializeLocalDirectoryRepository((File)new File(directory));
        RepositoryManager.addRepository((Repositories)RepositoryManager.getCentralRepository(), (Repository)repo);
        return repo;
    }

    private void createExample() {
        this.ldRepo.getDescriptions().addAll(this.exampleData.createExampleBaseMetricDescriptions((EList<Description>)this.ldRepo.getDescriptions()));
        this.ldRepo.getDescriptions().addAll(this.exampleData.createExampleMetricSetDescriptions((EList<Description>)this.ldRepo.getDescriptions()));
        this.exampleData.createExampleExperimentMetadata();
        this.ldRepo.getExperimentGroups().add((Object)this.exampleData.getExampleExperimentGroup());
        this.exampleData.simulateExperimentRun();
    }

    public void run() {
        try {
            MeasurementsUtility.ensureOpenRepository((Repository)this.ldRepo);
            this.createExample();
            MeasurementsUtility.ensureClosedRepository((Repository)this.ldRepo);
        }
        catch (DataNotAccessibleException e) {
            LOGGER.log(Level.SEVERE, "Error while accessing the datastore.", e);
        }
    }

    public static void main(String[] args) {
        PieChartStoreExample example = new PieChartStoreExample();
        example.run();
    }
}

