/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentanalysis.tests;

import java.util.Deque;
import java.util.LinkedList;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.palladiosimulator.experimentanalysis.FlushWindowStrategy;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

public class FlushWindowStrategyTest {
    private Deque<MeasuringValue> data;
    private FlushWindowStrategy strategyUnderTest;
    private Measure<Double, Duration> currentLowerBound;
    private Measure<Double, Duration> increment;
    private final MetricSetDescription metricDescription = MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC_TUPLE;

    @Before
    public void setUp() throws Exception {
        this.strategyUnderTest = new FlushWindowStrategy();
        this.data = new LinkedList<MeasuringValue>();
        this.currentLowerBound = Measure.valueOf((double)0.0, (Unit)SI.SECOND);
        this.increment = Measure.valueOf((double)5.0, (Unit)SI.SECOND);
    }

    @After
    public void tearDown() {
        this.data.clear();
    }

    @Test
    public void testAdjustData() {
        this.initiallyFillWindowWithMeasurements();
        this.mockMoveOn();
        this.strategyUnderTest.adjustData(this.data, this.currentLowerBound, this.increment);
        Assert.assertTrue((boolean)this.data.isEmpty());
    }

    private void mockMoveOn() {
        this.currentLowerBound = Measure.valueOf((double)((Double)this.currentLowerBound.getValue() + (Double)this.increment.getValue()), (Unit)SI.SECOND);
    }

    private void initiallyFillWindowWithMeasurements() {
        int i = 0;
        while (i < 10) {
            Measure pointInTimeMeasure = i % 2 == 0 ? Measure.valueOf((double)((double)i + 0.75), (Unit)SI.SECOND) : Measure.valueOf((double)(((double)i + 0.75) * 1000.0), (Unit)SI.MILLI((Unit)SI.SECOND));
            Measure stateMeasure = Measure.valueOf((long)42L, (Unit)Unit.ONE);
            this.data.addLast((MeasuringValue)new TupleMeasurement(this.metricDescription, new Measure[]{pointInTimeMeasure, stateMeasure}));
            ++i;
        }
    }
}

