/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentanalysis.tests;

import java.util.Deque;
import javax.measure.Measure;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.palladiosimulator.experimentanalysis.ISlidingWindowListener;
import org.palladiosimulator.experimentanalysis.ISlidingWindowMoveOnStrategy;
import org.palladiosimulator.experimentanalysis.SlidingWindow;
import org.palladiosimulator.measurementframework.BasicMeasurement;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

public abstract class SlidingWindowTest {
    protected SlidingWindow slidingWindowUnderTest;
    protected Measure<Double, Duration> windowLength;
    protected Measure<Double, Duration> currentLowerBound;
    protected Measure<Double, Duration> increment;
    protected MeasuringValue measurement;
    protected MeasuringValue wrongMetricMeasurement;
    protected Measure<Double, Duration> pointInTimeMeasure;
    protected Measure<Long, Dimensionless> stateMeasure;
    protected ISlidingWindowMoveOnStrategy dummyStrategy;
    protected ISlidingWindowListener windowListener;
    protected ISlidingWindowListener windowListenerWrongMetric;
    protected static final BaseMetricDescription windowMetricDescription = MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC;
    protected static final MetricSetDescription measurementsMetricDescription = MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC_TUPLE;
    protected static final BaseMetricDescription wrongMetricDescription = MetricDescriptionConstants.POINT_IN_TIME_METRIC;

    @Before
    public void setUp() throws Exception {
        this.windowLength = Measure.valueOf((double)10.0, (Unit)SI.SECOND);
        this.currentLowerBound = Measure.valueOf((double)0.0, (Unit)SI.SECOND);
        this.increment = Measure.valueOf((double)5.0, (Unit)SI.SECOND);
        this.pointInTimeMeasure = Measure.valueOf((double)1.0, (Unit)SI.SECOND);
        this.stateMeasure = Measure.valueOf((long)42L, (Unit)Unit.ONE);
        this.measurement = new TupleMeasurement(measurementsMetricDescription, new Measure[]{this.pointInTimeMeasure, this.stateMeasure});
        this.wrongMetricMeasurement = new BasicMeasurement(this.pointInTimeMeasure, wrongMetricDescription);
        this.dummyStrategy = new DummyMoveOnStrategy();
        this.windowListener = new DummySlidingWindowListener((MetricDescription)windowMetricDescription);
        this.windowListenerWrongMetric = new DummySlidingWindowListener((MetricDescription)wrongMetricDescription);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddMeasurementWrongMetric() {
        this.slidingWindowUnderTest.addMeasurement(this.wrongMetricMeasurement);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddMeasurementNull() {
        this.slidingWindowUnderTest.addMeasurement(null);
    }

    @Test
    public void testFlush() {
        this.slidingWindowUnderTest.addMeasurement(this.measurement);
        Assert.assertFalse((boolean)this.slidingWindowUnderTest.isEmpty());
        this.slidingWindowUnderTest.flush();
        Assert.assertTrue((boolean)this.slidingWindowUnderTest.isEmpty());
        Assert.assertEquals((long)0L, (long)this.slidingWindowUnderTest.getNumberOfElements());
    }

    @Test
    public void testGetCurrentUpperBound() {
        Measure expected = Measure.valueOf((double)((Double)this.currentLowerBound.getValue() + (Double)this.windowLength.getValue()), (Unit)SI.SECOND);
        Assert.assertEquals((Object)expected, (Object)this.slidingWindowUnderTest.getCurrentUpperBound());
    }

    @Test
    public void testGetEffectiveWindowLength() {
        Assert.assertEquals(this.windowLength, (Object)this.slidingWindowUnderTest.getEffectiveWindowLength());
    }

    @Test
    public void testGetIncrement() {
        Assert.assertEquals(this.increment, (Object)this.slidingWindowUnderTest.getIncrement());
    }

    @Test
    public void testGetAcceptedMetric() {
        Assert.assertEquals((Object)windowMetricDescription, (Object)this.slidingWindowUnderTest.getAcceptedMetric());
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)this.slidingWindowUnderTest.isEmpty());
        this.slidingWindowUnderTest.addMeasurement(this.measurement);
        Assert.assertFalse((boolean)this.slidingWindowUnderTest.isEmpty());
    }

    @Test
    public void testGetNumberOfElements() {
        Assert.assertEquals((long)0L, (long)this.slidingWindowUnderTest.getNumberOfElements());
        this.slidingWindowUnderTest.addMeasurement(this.measurement);
        Assert.assertEquals((long)1L, (long)this.slidingWindowUnderTest.getNumberOfElements());
    }

    @Test
    public void testAddObserver() {
        this.slidingWindowUnderTest.addObserver(this.windowListener);
        Assert.assertEquals((long)1L, (long)this.slidingWindowUnderTest.getAttachedObservers().size());
        Assert.assertTrue((boolean)this.slidingWindowUnderTest.getAttachedObservers().contains(this.windowListener));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddObserverNull() {
        this.slidingWindowUnderTest.addObserver(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddObserverWrongMetric() {
        this.slidingWindowUnderTest.addObserver(this.windowListenerWrongMetric);
    }

    @Test
    public void testRemoveObserver() {
        this.slidingWindowUnderTest.addObserver(this.windowListener);
        this.slidingWindowUnderTest.removeObserver((Object)this.windowListener);
        Assert.assertEquals((long)0L, (long)this.slidingWindowUnderTest.getAttachedObservers().size());
    }

    @Test
    public void testMoveOn() {
        SlidingWindowOnWindowFullEventMock window = new SlidingWindowOnWindowFullEventMock();
        window.mockOnWindowFullEvent();
        Measure expectedNewUpperBound = Measure.valueOf((double)((Double)this.currentLowerBound.getValue() + (Double)this.increment.getValue() + (Double)this.windowLength.getValue()), (Unit)SI.SECOND);
        Assert.assertEquals((Object)expectedNewUpperBound, (Object)window.getCurrentUpperBound());
    }

    static final class DummyMoveOnStrategy
    implements ISlidingWindowMoveOnStrategy {
        DummyMoveOnStrategy() {
        }

        public void adjustData(Deque<MeasuringValue> currentData, Measure<Double, Duration> newLowerBound, Measure<Double, Duration> increment) {
        }
    }

    private static final class DummySlidingWindowListener
    implements ISlidingWindowListener {
        private final MetricDescription expectedWindowDataMetric;

        private DummySlidingWindowListener(MetricDescription expectedWindowDataMetric) {
            this.expectedWindowDataMetric = expectedWindowDataMetric;
        }

        public void onSlidingWindowFull(Iterable<MeasuringValue> windowData, Measure<Double, Duration> windowLeftBound, Measure<Double, Duration> windowLength) {
        }

        public MetricDescription getExpectedWindowDataMetric() {
            return this.expectedWindowDataMetric;
        }
    }

    private final class SlidingWindowOnWindowFullEventMock
    extends SlidingWindow {
        public SlidingWindowOnWindowFullEventMock() {
            super(SlidingWindowTest.this.windowLength, SlidingWindowTest.this.increment, (MetricDescription)measurementsMetricDescription, SlidingWindowTest.this.dummyStrategy);
        }

        public void mockOnWindowFullEvent() {
            super.onWindowFullEvent();
        }
    }
}

