/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentanalysis.windowaggregators.tests;

import javax.measure.Measurable;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.palladiosimulator.experimentanalysis.windowaggregators.SlidingWindowExponentialSmoothingUtilizationAggregator;
import org.palladiosimulator.experimentanalysis.windowaggregators.tests.SlidingWindowUtilizationAggregatorTest;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.recorderframework.core.IRecorder;

public class SlidingWindowExponentialSmoothingUtilizationAggregatorTest
extends SlidingWindowUtilizationAggregatorTest {
    private static final Amount<Duration> ONE_SECOND = Amount.valueOf((long)1L, (Unit)SI.SECOND);
    private static final Amount<Duration> ZERO_DURATION = Amount.valueOf((double)0.0, (Unit)SI.SECOND);
    private Measure<Integer, Duration> samplingRate;
    private Amount<Duration> reportingPeriod;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.samplingRate = Measure.valueOf((int)5, (Unit)SI.SECOND);
        this.reportingPeriod = Amount.valueOf((double)0.5, (Unit)NonSI.MINUTE);
        this.windowLength = Measure.valueOf((double)this.reportingPeriod.doubleValue(NonSI.HOUR), (Unit)NonSI.HOUR);
        this.emptyUtilizationMeasurement = new TupleMeasurement(MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE_TUPLE, new Measure[]{this.windowLength, Measure.valueOf((double)0.0, (Unit)Unit.ONE)});
        this.aggregatorUnderTest = new SlidingWindowExponentialSmoothingUtilizationAggregator((MetricDescription)this.expectedWindowDataMetric, (IRecorder)this.dummyRecorder, this.samplingRate, this.reportingPeriod);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testGetSamplingRate() {
        Measurable actualRate = ((SlidingWindowExponentialSmoothingUtilizationAggregator)this.aggregatorUnderTest).getSamplingRate();
        Assert.assertEquals((double)this.samplingRate.doubleValue((Unit)SI.SECOND), (double)actualRate.doubleValue((Unit)SI.SECOND), (double)DELTA);
    }

    @Test
    public void testGetSmoothingFactor() {
        double actualFactor = ((SlidingWindowExponentialSmoothingUtilizationAggregator)this.aggregatorUnderTest).getSmoothingFactor();
        double expectedFactor = 1.0 - Math.exp(-this.samplingRate.doubleValue((Unit)SI.SECOND) / this.reportingPeriod.doubleValue((Unit)SI.SECOND));
        Assert.assertEquals((double)expectedFactor, (double)actualFactor, (double)DELTA);
    }

    @Override
    @Test
    public void testOnSlidingWindowFullUtilizationSameDurationUnits() {
        int i = 0;
        while (i < 30) {
            Measure pointInTimeMeasure = Measure.valueOf((double)((double)i + 0.5), (Unit)SI.SECOND);
            if (i % 2 == 0) {
                this.data.addLast(new TupleMeasurement(this.expectedWindowDataMetric, new Measure[]{pointInTimeMeasure, this.busyStateMeasure}));
            } else {
                this.data.addLast(new TupleMeasurement(this.expectedWindowDataMetric, new Measure[]{pointInTimeMeasure, this.idleStateMeasure}));
            }
            i += 5;
        }
        this.aggregatorUnderTest.onSlidingWindowFull((Iterable)this.data, this.currentLowerBound, this.windowLength);
        double smoothingFactor = 1.0 - Math.exp(-this.samplingRate.doubleValue((Unit)SI.SECOND) / this.reportingPeriod.doubleValue((Unit)SI.SECOND));
        double expectedLoad = 0.0;
        expectedLoad = smoothingFactor * this.busyStateMeasure.doubleValue(Unit.ONE);
        expectedLoad *= 1.0 - smoothingFactor;
        expectedLoad = expectedLoad * (1.0 - smoothingFactor) + smoothingFactor * this.busyStateMeasure.doubleValue(Unit.ONE);
        expectedLoad *= 1.0 - smoothingFactor;
        expectedLoad = expectedLoad * (1.0 - smoothingFactor) + smoothingFactor * this.busyStateMeasure.doubleValue(Unit.ONE);
        TupleMeasurement expected = new TupleMeasurement(MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE_TUPLE, new Measure[]{this.windowLength, Measure.valueOf((double)(expectedLoad *= 1.0 - smoothingFactor), (Unit)Unit.ONE)});
        this.assertLastRecordedMeasurementEquals((MeasuringValue)expected);
    }

    @Override
    @Test
    public void testOnSlidingWindowFullUtilizationDifferentDurationUnits() {
        int i = 0;
        while (i < 30) {
            Measure pointInTimeMeasure = Measure.valueOf((double)((double)i + 0.5), (Unit)SI.SECOND);
            if (i % 2 == 0) {
                this.data.addLast(new TupleMeasurement(this.expectedWindowDataMetric, new Measure[]{pointInTimeMeasure, this.busyStateMeasure}));
            } else {
                this.data.addLast(new TupleMeasurement(this.expectedWindowDataMetric, new Measure[]{pointInTimeMeasure.to(SI.DECI((Unit)NonSI.HOUR)), this.idleStateMeasure}));
            }
            i += 5;
        }
        this.aggregatorUnderTest.onSlidingWindowFull((Iterable)this.data, this.currentLowerBound, this.windowLength);
        double smoothingFactor = 1.0 - Math.exp(-this.samplingRate.doubleValue((Unit)SI.SECOND) / this.reportingPeriod.doubleValue((Unit)SI.SECOND));
        double expectedLoad = 0.0;
        expectedLoad = smoothingFactor * this.busyStateMeasure.doubleValue(Unit.ONE);
        expectedLoad *= 1.0 - smoothingFactor;
        expectedLoad = expectedLoad * (1.0 - smoothingFactor) + smoothingFactor * this.busyStateMeasure.doubleValue(Unit.ONE);
        expectedLoad *= 1.0 - smoothingFactor;
        expectedLoad = expectedLoad * (1.0 - smoothingFactor) + smoothingFactor * this.busyStateMeasure.doubleValue(Unit.ONE);
        TupleMeasurement expected = new TupleMeasurement(MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE_TUPLE, new Measure[]{this.windowLength, Measure.valueOf((double)(expectedLoad *= 1.0 - smoothingFactor), (Unit)Unit.ONE)});
        this.assertLastRecordedMeasurementEquals((MeasuringValue)expected);
    }

    @Override
    @Test
    public void testOnSlidingWindowFullNoUtilization() {
        int i = 0;
        while (i < 30) {
            this.data.addLast(new TupleMeasurement(this.expectedWindowDataMetric, new Measure[]{Measure.valueOf((double)((double)i + 0.1), (Unit)SI.SECOND), this.idleStateMeasure}));
            ++i;
        }
        this.aggregatorUnderTest.onSlidingWindowFull((Iterable)this.data, this.currentLowerBound, this.windowLength);
        this.assertLastRecordedMeasurementEquals(this.emptyUtilizationMeasurement);
    }

    @Test(expected=NullPointerException.class)
    public void testSlidingWindowUtilizationAggregatorCtorNullSamplingRate() {
        new SlidingWindowExponentialSmoothingUtilizationAggregator((MetricDescription)this.expectedWindowDataMetric, (IRecorder)this.dummyRecorder, null, ONE_SECOND);
    }

    @Test(expected=NullPointerException.class)
    public void testSlidingWindowUtilizationAggregatorCtorNullReportingPeriod() {
        new SlidingWindowExponentialSmoothingUtilizationAggregator((MetricDescription)this.expectedWindowDataMetric, (IRecorder)this.dummyRecorder, ONE_SECOND, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSlidingWindowUtilizationAggregatorCtorInvalidSamplingRate() {
        new SlidingWindowExponentialSmoothingUtilizationAggregator((MetricDescription)this.expectedWindowDataMetric, (IRecorder)this.dummyRecorder, ZERO_DURATION, ONE_SECOND);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSlidingWindowUtilizationAggregatorCtorInvalidReportingPeriod() {
        new SlidingWindowExponentialSmoothingUtilizationAggregator((MetricDescription)this.expectedWindowDataMetric, (IRecorder)this.dummyRecorder, ONE_SECOND, (Measurable)ONE_SECOND.opposite());
    }
}

