/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentanalysis.tests;

import java.util.Deque;
import java.util.LinkedList;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.palladiosimulator.experimentanalysis.DiscardAllElementsPriorToLowerBoundStrategy;
import org.palladiosimulator.experimentanalysis.ISlidingWindowMoveOnStrategy;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

public class DiscardAllElementsPriorToLowerBoundStrategyTest {
    private Deque<MeasuringValue> data;
    private ISlidingWindowMoveOnStrategy strategyUnderTest;
    private Measure<Double, Duration> currentLowerBound;
    private Measure<Double, Duration> increment;
    private MeasuringValue expectedMeasurement;
    private final MetricSetDescription metricDescription = MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC_TUPLE;

    @Before
    public void setUp() throws Exception {
        this.strategyUnderTest = new DiscardAllElementsPriorToLowerBoundStrategy();
        this.data = new LinkedList<MeasuringValue>();
        this.currentLowerBound = Measure.valueOf((double)0.0, (Unit)SI.SECOND);
        this.increment = Measure.valueOf((double)5.0, (Unit)SI.SECOND);
        this.expectedMeasurement = new TupleMeasurement(this.metricDescription, new Measure[]{Measure.valueOf((double)5.75, (Unit)SI.SECOND), Measure.valueOf((long)42L, (Unit)Unit.ONE)});
    }

    @After
    public void tearDown() {
        this.data.clear();
    }

    private void initiallyFillWindowWithMeasurements() {
        int i = 0;
        while (i < 10) {
            if (i == 5) {
                this.data.addLast(this.expectedMeasurement);
            } else {
                Measure pointInTimeMeasure = i % 2 == 0 ? Measure.valueOf((double)((double)i + 0.75), (Unit)SI.SECOND) : Measure.valueOf((double)(((double)i + 0.75) * 1000.0), (Unit)SI.MILLI((Unit)SI.SECOND));
                Measure stateMeasure = Measure.valueOf((long)42L, (Unit)Unit.ONE);
                this.data.addLast((MeasuringValue)new TupleMeasurement(this.metricDescription, new Measure[]{pointInTimeMeasure, stateMeasure}));
            }
            ++i;
        }
    }

    private void initiallyFillWindowWithMeasurementsOneElement() {
        this.data.addLast(this.expectedMeasurement);
    }

    private void initiallyFillWindowWithMeasurementsNoElementToKeep() {
        this.data.addLast((MeasuringValue)new TupleMeasurement(this.metricDescription, new Measure[]{Measure.valueOf((double)6.25E-4, (Unit)NonSI.HOUR), Measure.valueOf((long)42L, (Unit)Unit.ONE)}));
    }

    private void mockMoveOn() {
        this.currentLowerBound = Measure.valueOf((double)((Double)this.currentLowerBound.getValue() + (Double)this.increment.getValue()), (Unit)SI.SECOND);
    }

    @Test
    public void testAdjustDataOneElementAvailable() {
        this.initiallyFillWindowWithMeasurementsOneElement();
        this.mockMoveOn();
        this.strategyUnderTest.adjustData(this.data, this.currentLowerBound, this.increment);
        Assert.assertEquals((long)1L, (long)this.data.size());
        Assert.assertEquals((Object)this.expectedMeasurement, (Object)this.data.peekFirst());
    }

    @Test
    public void testAdjustDataOneElementAvailableNotToKeep() {
        this.initiallyFillWindowWithMeasurementsNoElementToKeep();
        this.mockMoveOn();
        this.strategyUnderTest.adjustData(this.data, this.currentLowerBound, this.increment);
        Assert.assertTrue((boolean)this.data.isEmpty());
        Assert.assertTrue((this.data.peekFirst() == null ? 1 : 0) != 0);
    }

    @Test
    public void testAdjustDataNoDataAvailable() {
        this.mockMoveOn();
        this.strategyUnderTest.adjustData(this.data, this.currentLowerBound, this.increment);
        Assert.assertEquals((long)0L, (long)this.data.size());
    }

    @Test
    public void testAdjustData() {
        this.initiallyFillWindowWithMeasurements();
        this.mockMoveOn();
        this.strategyUnderTest.adjustData(this.data, this.currentLowerBound, this.increment);
        Assert.assertEquals((long)5L, (long)this.data.size());
        Assert.assertEquals((Object)this.expectedMeasurement, (Object)this.data.peekFirst());
    }
}

