/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentanalysis.tests;

import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.palladiosimulator.experimentanalysis.ISlidingWindowListener;
import org.palladiosimulator.experimentanalysis.ISlidingWindowMoveOnStrategy;
import org.palladiosimulator.experimentanalysis.SlidingWindow;
import org.palladiosimulator.experimentanalysis.SlidingWindowRecorder;
import org.palladiosimulator.experimentanalysis.tests.SlidingWindowTest;
import org.palladiosimulator.experimentanalysis.tests.utils.StoreLastMeasurementRecorder;
import org.palladiosimulator.experimentanalysis.windowaggregators.SlidingWindowUtilizationAggregator;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.recorderframework.core.IRecorder;

public class SlidingWindowRecorderTest {
    private SlidingWindowRecorder recorderUnderTest;
    private SlidingWindow window;
    private Measure<Double, Duration> windowLength;
    private MeasuringValue measurement;
    private ISlidingWindowListener windowListener;

    @Before
    public void setUp() throws Exception {
        this.windowLength = Measure.valueOf((double)10.0, (Unit)SI.SECOND);
        this.measurement = new TupleMeasurement(MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC_TUPLE, new Measure[]{Measure.valueOf((double)3.5, (Unit)SI.SECOND), Measure.valueOf((long)1337L, (Unit)Unit.ONE)});
        this.window = new SlidingWindowMock(this.windowLength, (MetricDescription)MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC_TUPLE, new SlidingWindowTest.DummyMoveOnStrategy());
        this.windowListener = new SlidingWindowUtilizationAggregator((MetricDescription)MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC_TUPLE, (IRecorder)new StoreLastMeasurementRecorder());
        this.recorderUnderTest = new SlidingWindowRecorder(this.window, this.windowListener);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSlidingWindowRecorderCtorNoWindow() {
        new SlidingWindowRecorder(null, this.windowListener);
    }

    @Test
    public void testWriteData() {
        Assert.assertTrue((boolean)this.window.isEmpty());
        this.recorderUnderTest.writeData(this.measurement);
        Assert.assertFalse((boolean)this.window.isEmpty());
        Assert.assertEquals((long)1L, (long)this.window.getNumberOfElements());
    }

    @Test
    public void testFlush() {
        this.recorderUnderTest.writeData(this.measurement);
        this.recorderUnderTest.flush();
        Assert.assertTrue((boolean)this.window.isEmpty());
    }

    private static final class SlidingWindowMock
    extends SlidingWindow {
        public SlidingWindowMock(Measure<Double, Duration> windowLength, MetricDescription acceptedMetrics, ISlidingWindowMoveOnStrategy moveOnStrategy) {
            super(windowLength, acceptedMetrics, moveOnStrategy);
        }

        public SlidingWindowMock(Measure<Double, Duration> windowLength, Measure<Double, Duration> increment, MetricDescription acceptedMetrics, ISlidingWindowMoveOnStrategy moveOnStrategy) {
            super(windowLength, increment, acceptedMetrics, moveOnStrategy);
        }
    }
}

