/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentanalysis.windowaggregators.tests;

import de.uka.ipd.sdq.identifier.Identifier;
import java.util.List;
import java.util.stream.Collectors;
import javax.measure.Measure;
import javax.measure.quantity.Dimensionless;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.palladiosimulator.experimentanalysis.windowaggregators.SlidingWindowUtilizationAggregator;
import org.palladiosimulator.experimentanalysis.windowaggregators.tests.SlidingWindowAggregatorTest;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.recorderframework.core.IRecorder;

public class SlidingWindowUtilizationAggregatorTest
extends SlidingWindowAggregatorTest {
    protected MeasuringValue emptyUtilizationMeasurement;
    private MeasuringValue expectedNotEmptyUtilizationMeasurement;
    protected MetricSetDescription expectedWindowDataMetric;
    protected Measure<Long, Dimensionless> idleStateMeasure;
    protected Measure<Long, Dimensionless> busyStateMeasure;
    protected static final double DELTA = Math.pow(10.0, -12.0);

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.expectedWindowDataMetric = MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC_TUPLE;
        this.aggregatorUnderTest = new SlidingWindowUtilizationAggregator((MetricDescription)this.expectedWindowDataMetric, (IRecorder)this.dummyRecorder);
        this.emptyUtilizationMeasurement = this.createEmptyUtilizationTupleMeasurement();
        this.expectedNotEmptyUtilizationMeasurement = this.createUtilizationTupleMeasurement(0.7);
        this.idleStateMeasure = Measure.valueOf((long)0L, (Unit)Unit.ONE);
        this.busyStateMeasure = Measure.valueOf((long)42L, (Unit)Unit.ONE);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    private MeasuringValue createUtilizationTupleMeasurement(double utilization) {
        Measure resultPointInTimeMeasure = Measure.valueOf((double)(this.currentLowerBound.doubleValue((Unit)SI.SECOND) + this.windowLength.doubleValue((Unit)SI.SECOND)), (Unit)SI.SECOND);
        return new TupleMeasurement(MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE_TUPLE, new Measure[]{resultPointInTimeMeasure, Measure.valueOf((double)utilization, (Unit)Unit.ONE)});
    }

    private MeasuringValue createEmptyUtilizationTupleMeasurement() {
        return this.createUtilizationTupleMeasurement(0.0);
    }

    private void addStateOfActiveResourceTupleMeasurementsNoUtilization() {
        Measure pointInTimeMeasure = Measure.valueOf((double)0.0, (Unit)SI.SECOND);
        this.data.addLast(new TupleMeasurement(this.expectedWindowDataMetric, new Measure[]{pointInTimeMeasure, this.idleStateMeasure}));
        pointInTimeMeasure = Measure.valueOf((double)3.0, (Unit)SI.SECOND);
        this.data.addLast(new TupleMeasurement(this.expectedWindowDataMetric, new Measure[]{pointInTimeMeasure, this.idleStateMeasure}));
        pointInTimeMeasure = Measure.valueOf((double)6.0, (Unit)SI.SECOND);
        this.data.addLast(new TupleMeasurement(this.expectedWindowDataMetric, new Measure[]{pointInTimeMeasure, this.idleStateMeasure}));
    }

    private void addStateOfActiveResourceTupleMeasurementsUtilizationSameDurationUnits() {
        Measure pointInTimeMeasure = Measure.valueOf((double)0.0, (Unit)SI.SECOND);
        this.data.addLast(new TupleMeasurement(this.expectedWindowDataMetric, new Measure[]{pointInTimeMeasure, this.busyStateMeasure}));
        pointInTimeMeasure = Measure.valueOf((double)3.0, (Unit)SI.SECOND);
        this.data.addLast(new TupleMeasurement(this.expectedWindowDataMetric, new Measure[]{pointInTimeMeasure, this.idleStateMeasure}));
        pointInTimeMeasure = Measure.valueOf((double)6.0, (Unit)SI.SECOND);
        this.data.addLast(new TupleMeasurement(this.expectedWindowDataMetric, new Measure[]{pointInTimeMeasure, this.busyStateMeasure}));
    }

    private void addStateOfActiveResourceTupleMeasurementsUtilizationDifferentDurationUnits() {
        Measure pointInTimeMeasure = Measure.valueOf((double)0.0, (Unit)SI.SECOND);
        this.data.addLast(new TupleMeasurement(this.expectedWindowDataMetric, new Measure[]{pointInTimeMeasure, this.busyStateMeasure}));
        pointInTimeMeasure = Measure.valueOf((double)3000.0, (Unit)SI.MILLI((Unit)SI.SECOND));
        this.data.addLast(new TupleMeasurement(this.expectedWindowDataMetric, new Measure[]{pointInTimeMeasure, this.idleStateMeasure}));
        pointInTimeMeasure = Measure.valueOf((double)600.0, (Unit)SI.CENTI((Unit)SI.SECOND));
        this.data.addLast(new TupleMeasurement(this.expectedWindowDataMetric, new Measure[]{pointInTimeMeasure, this.busyStateMeasure}));
    }

    @Test(expected=NullPointerException.class)
    public void testSlidingWindowUtilizationAggregatorCtorNullMetric() {
        new SlidingWindowUtilizationAggregator(null, (IRecorder)this.dummyRecorder);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSlidingWindowUtilizationAggregatorCtorWrongMetric() {
        MetricSetDescription wrongMetric = MetricDescriptionConstants.COST_OVER_TIME;
        new SlidingWindowUtilizationAggregator((MetricDescription)wrongMetric, (IRecorder)this.dummyRecorder);
    }

    @Test
    public void testGetExpectedWindowDataMetric() {
        Assert.assertEquals((Object)this.expectedWindowDataMetric, (Object)this.aggregatorUnderTest.getExpectedWindowDataMetric());
    }

    @Test
    public void testGetAllowedWindowDataMetrics() {
        List allowedMetricIds = SlidingWindowUtilizationAggregator.getAllowedWindowDataMetrics().stream().map(Identifier::getId).collect(Collectors.toList());
        Assert.assertEquals((long)2L, (long)allowedMetricIds.size());
        Assert.assertTrue((boolean)allowedMetricIds.contains(MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC_TUPLE.getId()));
        Assert.assertTrue((boolean)allowedMetricIds.contains(MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE_TUPLE.getId()));
    }

    @Test
    public void testOnSlidingWindowFullEmptyData() {
        this.aggregatorUnderTest.onSlidingWindowFull((Iterable)this.data, this.currentLowerBound, this.windowLength);
        this.assertLastRecordedMeasurementEquals(this.emptyUtilizationMeasurement);
    }

    @Test
    public void testOnSlidingWindowFullNoUtilization() {
        this.addStateOfActiveResourceTupleMeasurementsNoUtilization();
        this.aggregatorUnderTest.onSlidingWindowFull((Iterable)this.data, this.currentLowerBound, this.windowLength);
        this.assertLastRecordedMeasurementEquals(this.emptyUtilizationMeasurement);
    }

    @Test
    public void testOnSlidingWindowFullUtilizationSameDurationUnits() {
        this.addStateOfActiveResourceTupleMeasurementsUtilizationSameDurationUnits();
        this.aggregatorUnderTest.onSlidingWindowFull((Iterable)this.data, this.currentLowerBound, this.windowLength);
        this.assertLastRecordedMeasurementEquals(this.expectedNotEmptyUtilizationMeasurement);
    }

    @Test
    public void testOnSlidingWindowFullUtilizationDifferentDurationUnits() {
        this.addStateOfActiveResourceTupleMeasurementsUtilizationDifferentDurationUnits();
        this.aggregatorUnderTest.onSlidingWindowFull((Iterable)this.data, this.currentLowerBound, this.windowLength);
        this.assertLastRecordedMeasurementEquals(this.expectedNotEmptyUtilizationMeasurement);
    }

    protected final void assertLastRecordedMeasurementEquals(MeasuringValue expected) {
        MeasuringValue lastMeasurement = this.dummyRecorder.getLastMeasurement();
        Assert.assertNotNull((Object)lastMeasurement);
        SlidingWindowUtilizationAggregatorTest.assertMeasurementsEqual(expected, lastMeasurement);
    }

    private static void assertMeasurementsEqual(MeasuringValue expected, MeasuringValue actual) {
        Measure expectedUtilization = expected.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE);
        Measure actualUtilization = actual.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE);
        Measure expectedPointInTime = expected.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
        Measure actualPointInTime = actual.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
        Assert.assertEquals((double)expectedUtilization.doubleValue(Unit.ONE), (double)actualUtilization.doubleValue(Unit.ONE), (double)DELTA);
        Assert.assertEquals((double)expectedPointInTime.doubleValue((Unit)SI.SECOND), (double)actualPointInTime.doubleValue((Unit)SI.SECOND), (double)DELTA);
    }
}

