/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentanalysis.utilizationfilter;

import javax.measure.Measurable;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import org.palladiosimulator.experimentanalysis.ISlidingWindowListener;
import org.palladiosimulator.experimentanalysis.ISlidingWindowMoveOnStrategy;
import org.palladiosimulator.experimentanalysis.KeepLastElementPriorToLowerBoundStrategy;
import org.palladiosimulator.experimentanalysis.SlidingWindow;
import org.palladiosimulator.experimentanalysis.windowaggregators.SlidingWindowUtilizationAggregator;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

final class UtilizationFilterSlidingWindow
extends SlidingWindow {
    UtilizationFilterSlidingWindow(Measure<Double, Duration> windowLength, SlidingWindowUtilizationAggregator aggregator) {
        this(windowLength, windowLength, aggregator);
    }

    UtilizationFilterSlidingWindow(Measure<Double, Duration> windowLength, Measure<Double, Duration> increment, SlidingWindowUtilizationAggregator aggregator) {
        super(windowLength, increment, aggregator.getExpectedWindowDataMetric(), (ISlidingWindowMoveOnStrategy)new KeepLastElementPriorToLowerBoundStrategy());
        this.addObserver((ISlidingWindowListener)aggregator);
    }

    void noMoreDataAvailable() {
        this.onWindowFullEvent();
    }

    public void addMeasurement(MeasuringValue newMeasurement) {
        super.checkAddMeasurementPrerequisites(newMeasurement);
        Measure pointInTime = newMeasurement.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
        while (pointInTime.compareTo((Measurable)this.getCurrentUpperBound()) > 0) {
            this.onWindowFullEvent();
        }
        this.addMeasurementInternal(newMeasurement);
    }
}

