/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentanalysis.utilizationfilter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;
import org.eclipse.ui.IPersistableElement;
import org.palladiosimulator.edp2.datastream.IDataSink;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.datastream.configurable.PropertyConfigurable;
import org.palladiosimulator.edp2.datastream.filter.AbstractAdapter;
import org.palladiosimulator.edp2.datastream.filter.IFilter;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.experimentanalysis.utilizationfilter.UtilizationFilterConfiguration;
import org.palladiosimulator.experimentanalysis.utilizationfilter.UtilizationFilterInputFactory;
import org.palladiosimulator.experimentanalysis.utilizationfilter.UtilizationFilterSlidingWindow;
import org.palladiosimulator.experimentanalysis.windowaggregators.SlidingWindowUtilizationAggregator;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.recorderframework.core.IRecorder;
import org.palladiosimulator.recorderframework.core.config.IRecorderConfiguration;

public final class UtilizationFilter
extends AbstractAdapter
implements IFilter,
IPersistable,
IPersistableElement {
    private static final MetricDescription FILTER_RESULT_METRIC = MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE_TUPLE;
    private static final MetricDescription FILTER_INPUT_METRIC = MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC_TUPLE;

    public UtilizationFilter() {
        super(FILTER_RESULT_METRIC);
    }

    public UtilizationFilter(IDataSource datasource) {
        super(datasource, FILTER_RESULT_METRIC);
        if (!datasource.isCompatibleWith(FILTER_INPUT_METRIC)) {
            throw new IllegalArgumentException("The data source does not provide the necessary input metric for this adapter!");
        }
    }

    public boolean canAccept(IDataSource dataSource) {
        MetricDescription metric = Objects.requireNonNull(dataSource).getMetricDesciption();
        return metric == FILTER_INPUT_METRIC || metric == FILTER_RESULT_METRIC || MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)FILTER_INPUT_METRIC, (MetricDescription)metric) || MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)FILTER_RESULT_METRIC, (MetricDescription)metric);
    }

    public IDataStream<MeasuringValue> getDataStream() {
        if (this.canAccept(Objects.requireNonNull(this.getDataSource(), "No input data available. UtilizationFilter cannot be applied."))) {
            IDataStream inputData = this.getDataSource().getDataStream();
            return new UtilizationFilterOutputDataStream((IDataStream<MeasuringValue>)inputData, inputData.getMetricDesciption());
        }
        throw new AssertionError((Object)"Can accept was not called beforehand!");
    }

    public PropertyConfigurable createProperties() {
        return new UtilizationFilterConfiguration();
    }

    public String getFactoryId() {
        return UtilizationFilterInputFactory.FACTORY_ID;
    }

    public void saveState(IMemento memento) {
        UtilizationFilterInputFactory.saveState((IMemento)memento, (IDataSink)this);
    }

    private final class UtilizationFilterOutputDataStream
    implements IDataStream<MeasuringValue>,
    IRecorder {
        private final IDataStream<MeasuringValue> inputData;
        private final List<MeasuringValue> outputData;
        private final UtilizationFilterSlidingWindow slidingWindow;

        private UtilizationFilterOutputDataStream(IDataStream<MeasuringValue> inputData, MetricDescription inputMetric) {
            Measure<Double, Duration> windowLength = ((UtilizationFilterConfiguration)UtilizationFilter.this.getConfiguration()).getWindowLength();
            Measure<Double, Duration> windowIncrement = ((UtilizationFilterConfiguration)UtilizationFilter.this.getConfiguration()).getWindowIncrement();
            this.slidingWindow = new UtilizationFilterSlidingWindow(windowLength, windowIncrement, new SlidingWindowUtilizationAggregator(inputMetric, (IRecorder)this));
            this.inputData = inputData;
            this.outputData = new ArrayList<MeasuringValue>();
            this.initializeOutputStream();
        }

        private void initializeOutputStream() {
            this.inputData.forEach(this.slidingWindow::addMeasurement);
            this.slidingWindow.noMoreDataAvailable();
        }

        public Iterator<MeasuringValue> iterator() {
            return this.outputData.iterator();
        }

        public MetricDescription getMetricDesciption() {
            return FILTER_RESULT_METRIC;
        }

        public boolean isCompatibleWith(MetricDescription other) {
            return this.getMetricDesciption().equals(other);
        }

        public void close() {
            this.inputData.close();
            this.flush();
        }

        public int size() {
            return this.outputData.size();
        }

        public void initialize(IRecorderConfiguration recorderConfiguration) {
        }

        public void writeData(MeasuringValue measurement) {
            this.outputData.add(measurement);
        }

        public void flush() {
            this.outputData.clear();
        }

        public void newMeasurementAvailable(MeasuringValue newMeasurement) {
        }

        public void preUnregister() {
        }
    }
}

