/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentanalysis;

import java.util.Deque;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import org.palladiosimulator.experimentanalysis.ISlidingWindowMoveOnStrategy;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

public final class KeepLastElementPriorToLowerBoundStrategy
implements ISlidingWindowMoveOnStrategy {
    static boolean isFirstElementPriorToCurrentLowerBound(Deque<MeasuringValue> currentData, Measure<Double, Duration> newLowerBound) {
        assert (!currentData.isEmpty());
        Measure pointInTime = currentData.peekFirst().getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
        return pointInTime.compareTo(newLowerBound) < 0;
    }

    @Override
    public void adjustData(Deque<MeasuringValue> currentData, Measure<Double, Duration> newLowerBound, Measure<Double, Duration> increment) {
        if (!currentData.isEmpty() && KeepLastElementPriorToLowerBoundStrategy.isFirstElementPriorToCurrentLowerBound(currentData, newLowerBound)) {
            MeasuringValue first = currentData.pollFirst();
            while (!currentData.isEmpty() && KeepLastElementPriorToLowerBoundStrategy.isFirstElementPriorToCurrentLowerBound(currentData, newLowerBound)) {
                first = currentData.pollFirst();
            }
            currentData.addFirst(first);
        }
    }
}

