/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentanalysis.windowaggregators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import org.palladiosimulator.experimentanalysis.ISlidingWindowListener;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.recorderframework.core.IRecorder;

public abstract class SlidingWindowAggregator
implements ISlidingWindowListener {
    private final Collection<IRecorder> recordersToWriteInto = new ArrayList<IRecorder>();

    public SlidingWindowAggregator() {
    }

    public SlidingWindowAggregator(IRecorder recorderToWriteInto) {
        this.recordersToWriteInto.add(Objects.requireNonNull(recorderToWriteInto, "Given recorder must not be null."));
    }

    public SlidingWindowAggregator(Collection<IRecorder> recordersToWriteInto) {
        if (Objects.requireNonNull(recordersToWriteInto).isEmpty()) {
            throw new IllegalArgumentException("Given recorders collection must contain at least one recorder.");
        }
        this.recordersToWriteInto.addAll(recordersToWriteInto);
    }

    public void addRecorder(IRecorder recorder) {
        this.recordersToWriteInto.add(Objects.requireNonNull(recorder));
    }

    protected abstract MeasuringValue processWindowData(Iterable<MeasuringValue> var1, Measure<Double, Duration> var2, Measure<Double, Duration> var3);

    private void writeToRecorder(MeasuringValue newMeasurement) {
        this.recordersToWriteInto.forEach(recorder -> recorder.writeData(newMeasurement));
    }

    @Override
    public final void onSlidingWindowFull(Iterable<MeasuringValue> windowData, Measure<Double, Duration> windowLeftBound, Measure<Double, Duration> windowLength) {
        this.writeToRecorder(this.processWindowData(windowData, windowLeftBound, windowLength));
    }
}

