/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentanalysis.utilizationfilter;

import java.util.HashMap;
import java.util.Map;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.palladiosimulator.edp2.datastream.configurable.reflective.ConfigurationProperty;
import org.palladiosimulator.edp2.datastream.configurable.reflective.ReflectivePropertyConfigurable;

public final class UtilizationFilterConfiguration
extends ReflectivePropertyConfigurable {
    public static final String WINDOW_LENGTH_KEY = "windowLength";
    public static final String WINDOW_INCREMENT_KEY = "windowIncrement";
    private static final Measure<Double, Duration> DEFAULT_WINDOW_LENGTH = Measure.valueOf((double)10.0, (Unit)SI.SECOND);
    private static final Measure<Double, Duration> DEFAULT_WINDOW_INCREMENT = Measure.valueOf((double)10.0, (Unit)SI.SECOND);
    @ConfigurationProperty(description="A measure denoting the current window length.")
    private Measure<Double, Duration> windowLength;
    @ConfigurationProperty(description="A measure denoting the current window increment.")
    private Measure<Double, Duration> windowIncrement;

    public static Measure<Double, Duration> getDefaultWindowIncrement() {
        return DEFAULT_WINDOW_INCREMENT;
    }

    public static Measure<Double, Duration> getDefaultWindowLength() {
        return DEFAULT_WINDOW_LENGTH;
    }

    public Measure<Double, Duration> getWindowIncrement() {
        return this.windowIncrement;
    }

    public Measure<Double, Duration> getWindowLength() {
        return this.windowLength;
    }

    public Map<String, Object> getDefaultConfiguration() {
        HashMap<String, Object> result = new HashMap<String, Object>(super.getDefaultConfiguration());
        result.put(WINDOW_LENGTH_KEY, DEFAULT_WINDOW_LENGTH);
        result.put(WINDOW_INCREMENT_KEY, DEFAULT_WINDOW_INCREMENT);
        return result;
    }

    public void propertyChanged(String key, Object oldValue, Object newValue) {
        Measure<Double, Duration> checkedValue = newValue;
        if (newValue != this.getNotSetConstant() && (WINDOW_LENGTH_KEY.equals(key) || WINDOW_INCREMENT_KEY.equals(key))) {
            checkedValue = this.checkGetDurationMeasure(checkedValue);
        }
        super.propertyChanged(key, oldValue, (Object)checkedValue);
    }

    private Measure<Double, Duration> checkGetDurationMeasure(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Given measure must not be null.");
        }
        if (!(value instanceof Measure)) {
            throw new IllegalArgumentException("Given measure must be a valid JScience measure.");
        }
        Measure measure = (Measure)value;
        if (!(measure.getValue() instanceof Number) || !Duration.UNIT.isCompatible(measure.getUnit())) {
            throw new IllegalArgumentException("Given measure must be a valid JScience duration measure.");
        }
        Number measureValue = (Number)measure.getValue();
        if (Double.compare(0.0, measureValue.doubleValue()) >= 0) {
            throw new IllegalArgumentException("Given measure must denote a positive duration.");
        }
        return Measure.valueOf((double)measureValue.doubleValue(), (Unit)measure.getUnit());
    }
}

