/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementframework.measureprovider;

import java.util.List;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import org.palladiosimulator.measurementframework.BasicMeasurement;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.measureprovider.IMeasureProvider;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;

public abstract class AbstractMeasureProvider
implements IMeasureProvider {
    protected AbstractMeasureProvider() {
    }

    public <V, Q extends Quantity> Measure<V, Q> getMeasureForMetric(MetricDescription wantedMetric) {
        if (wantedMetric == null || !(wantedMetric instanceof BaseMetricDescription)) {
            throw new IllegalArgumentException("Only base metrics have measures attached.");
        }
        MeasuringValue wantedMeasurement = this.getMeasurementForMetric(wantedMetric);
        if (wantedMeasurement == null || !(wantedMeasurement instanceof BasicMeasurement)) {
            throw new IllegalStateException("Measurement for a base metric is not a BasicMeasurement.");
        }
        BasicMeasurement basicMeasurement = (BasicMeasurement)wantedMeasurement;
        return basicMeasurement.getMeasure();
    }

    public abstract MeasuringValue getMeasurementForMetric(MetricDescription var1);

    @Override
    public abstract List<Measure<?, ?>> asList();

    @Override
    public Measure<?, ?>[] asArray() {
        List<Measure<?, ?>> asList = this.asList();
        Measure[] result = new Measure[asList.size()];
        int i = 0;
        while (i < asList.size()) {
            result[i] = asList.get(i);
            ++i;
        }
        return result;
    }
}

