/**
 */
package org.palladiosimulator.monitorrepository.util;

import de.uka.ipd.sdq.identifier.util.IdentifierValidator;

import java.util.Map;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.EObjectValidator;

import org.palladiosimulator.monitorrepository.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Validator</b> for the model.
 * <!-- end-user-doc -->
 * @see org.palladiosimulator.monitorrepository.MonitorRepositoryPackage
 * @generated
 */
public class MonitorRepositoryValidator extends EObjectValidator
{
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final MonitorRepositoryValidator INSTANCE = new MonitorRepositoryValidator();

	/**
	 * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.common.util.Diagnostic#getSource()
	 * @see org.eclipse.emf.common.util.Diagnostic#getCode()
	 * @generated
	 */
	public static final String DIAGNOSTIC_SOURCE = "org.palladiosimulator.monitorrepository";

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;

	/**
	 * The cached base package validator.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IdentifierValidator identifierValidator;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MonitorRepositoryValidator()
	{
		super();
		identifierValidator = IdentifierValidator.INSTANCE;
	}

	/**
	 * Returns the package of this validator switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EPackage getEPackage()
	{
	  return MonitorRepositoryPackage.eINSTANCE;
	}

	/**
	 * Calls <code>validateXXX</code> for the corresponding classifier of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		switch (classifierID)
		{
			case MonitorRepositoryPackage.MONITOR_REPOSITORY:
				return validateMonitorRepository((MonitorRepository)value, diagnostics, context);
			case MonitorRepositoryPackage.MONITOR:
				return validateMonitor((Monitor)value, diagnostics, context);
			case MonitorRepositoryPackage.MEASUREMENT_SPECIFICATION:
				return validateMeasurementSpecification((MeasurementSpecification)value, diagnostics, context);
			case MonitorRepositoryPackage.STATISTICAL_CHARACTERIZATION:
				return validateStatisticalCharacterization((StatisticalCharacterization)value, diagnostics, context);
			case MonitorRepositoryPackage.ARITHMETIC_MEAN:
				return validateArithmeticMean((ArithmeticMean)value, diagnostics, context);
			case MonitorRepositoryPackage.HARMONIC_MEAN:
				return validateHarmonicMean((HarmonicMean)value, diagnostics, context);
			case MonitorRepositoryPackage.GEOMETRIC_MEAN:
				return validateGeometricMean((GeometricMean)value, diagnostics, context);
			case MonitorRepositoryPackage.MEDIAN:
				return validateMedian((Median)value, diagnostics, context);
			case MonitorRepositoryPackage.PROCESSING_TYPE:
				return validateProcessingType((ProcessingType)value, diagnostics, context);
			case MonitorRepositoryPackage.AGGREGATION:
				return validateAggregation((Aggregation)value, diagnostics, context);
			case MonitorRepositoryPackage.MEASUREMENT_DRIVEN_AGGREGATION:
				return validateMeasurementDrivenAggregation((MeasurementDrivenAggregation)value, diagnostics, context);
			case MonitorRepositoryPackage.FIXED_SIZE_AGGREGATION:
				return validateFixedSizeAggregation((FixedSizeAggregation)value, diagnostics, context);
			case MonitorRepositoryPackage.TIME_DRIVEN_AGGREGATION:
				return validateTimeDrivenAggregation((TimeDrivenAggregation)value, diagnostics, context);
			case MonitorRepositoryPackage.TIME_DRIVEN:
				return validateTimeDriven((TimeDriven)value, diagnostics, context);
			case MonitorRepositoryPackage.VARIABLE_SIZE_AGGREGATION:
				return validateVariableSizeAggregation((VariableSizeAggregation)value, diagnostics, context);
			case MonitorRepositoryPackage.FEED_THROUGH:
				return validateFeedThrough((FeedThrough)value, diagnostics, context);
			default:
				return true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateMonitorRepository(MonitorRepository monitorRepository, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(monitorRepository, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(monitorRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(monitorRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(monitorRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(monitorRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(monitorRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(monitorRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(monitorRepository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(monitorRepository, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(monitorRepository, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateMonitor(Monitor monitor, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment(monitor, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(monitor, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(monitor, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(monitor, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(monitor, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(monitor, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(monitor, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(monitor, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(monitor, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(monitor, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateMeasurementSpecification(MeasurementSpecification measurementSpecification, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)measurementSpecification, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)measurementSpecification, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)measurementSpecification, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)measurementSpecification, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)measurementSpecification, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)measurementSpecification, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)measurementSpecification, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)measurementSpecification, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)measurementSpecification, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(measurementSpecification, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateStatisticalCharacterization(StatisticalCharacterization statisticalCharacterization, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return validate_EveryDefaultConstraint((EObject)statisticalCharacterization, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateArithmeticMean(ArithmeticMean arithmeticMean, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return validate_EveryDefaultConstraint((EObject)arithmeticMean, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateHarmonicMean(HarmonicMean harmonicMean, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return validate_EveryDefaultConstraint((EObject)harmonicMean, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateGeometricMean(GeometricMean geometricMean, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return validate_EveryDefaultConstraint((EObject)geometricMean, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateMedian(Median median, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return validate_EveryDefaultConstraint((EObject)median, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateProcessingType(ProcessingType processingType, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)processingType, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)processingType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)processingType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)processingType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)processingType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)processingType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)processingType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)processingType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)processingType, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(processingType, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAggregation(Aggregation aggregation, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)aggregation, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)aggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)aggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)aggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)aggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)aggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)aggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)aggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)aggregation, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(aggregation, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateMeasurementDrivenAggregation(MeasurementDrivenAggregation measurementDrivenAggregation, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)measurementDrivenAggregation, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)measurementDrivenAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)measurementDrivenAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)measurementDrivenAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)measurementDrivenAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)measurementDrivenAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)measurementDrivenAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)measurementDrivenAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)measurementDrivenAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(measurementDrivenAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validateMeasurementDrivenAggregation_frequency(measurementDrivenAggregation, diagnostics, context);
		return result;
	}

	/**
	 * The cached validation expression for the frequency constraint of '<em>Measurement Driven Aggregation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String MEASUREMENT_DRIVEN_AGGREGATION__FREQUENCY__EEXPRESSION = "self.frequency > 0";

	/**
	 * Validates the frequency constraint of '<em>Measurement Driven Aggregation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateMeasurementDrivenAggregation_frequency(MeasurementDrivenAggregation measurementDrivenAggregation, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(MonitorRepositoryPackage.Literals.MEASUREMENT_DRIVEN_AGGREGATION,
				 (EObject)measurementDrivenAggregation,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL",
				 "frequency",
				 MEASUREMENT_DRIVEN_AGGREGATION__FREQUENCY__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateFixedSizeAggregation(FixedSizeAggregation fixedSizeAggregation, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)fixedSizeAggregation, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)fixedSizeAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)fixedSizeAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)fixedSizeAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)fixedSizeAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)fixedSizeAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)fixedSizeAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)fixedSizeAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)fixedSizeAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(fixedSizeAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validateMeasurementDrivenAggregation_frequency(fixedSizeAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validateFixedSizeAggregation_measNum(fixedSizeAggregation, diagnostics, context);
		return result;
	}

	/**
	 * The cached validation expression for the measNum constraint of '<em>Fixed Size Aggregation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String FIXED_SIZE_AGGREGATION__MEAS_NUM__EEXPRESSION = "self.numberOfMeasurements > 0";

	/**
	 * Validates the measNum constraint of '<em>Fixed Size Aggregation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateFixedSizeAggregation_measNum(FixedSizeAggregation fixedSizeAggregation, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(MonitorRepositoryPackage.Literals.FIXED_SIZE_AGGREGATION,
				 (EObject)fixedSizeAggregation,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL",
				 "measNum",
				 FIXED_SIZE_AGGREGATION__MEAS_NUM__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateTimeDrivenAggregation(TimeDrivenAggregation timeDrivenAggregation, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)timeDrivenAggregation, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)timeDrivenAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)timeDrivenAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)timeDrivenAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)timeDrivenAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)timeDrivenAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)timeDrivenAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)timeDrivenAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)timeDrivenAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(timeDrivenAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validateTimeDriven_windowLength(timeDrivenAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validateTimeDriven_windowIncrement(timeDrivenAggregation, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateTimeDriven(TimeDriven timeDriven, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)timeDriven, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)timeDriven, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)timeDriven, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)timeDriven, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)timeDriven, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)timeDriven, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)timeDriven, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)timeDriven, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)timeDriven, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(timeDriven, diagnostics, context);
		if (result || diagnostics != null) result &= validateTimeDriven_windowLength(timeDriven, diagnostics, context);
		if (result || diagnostics != null) result &= validateTimeDriven_windowIncrement(timeDriven, diagnostics, context);
		return result;
	}

	/**
	 * The cached validation expression for the windowLength constraint of '<em>Time Driven</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String TIME_DRIVEN__WINDOW_LENGTH__EEXPRESSION = "self.windowLength > 0.0";

	/**
	 * Validates the windowLength constraint of '<em>Time Driven</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateTimeDriven_windowLength(TimeDriven timeDriven, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(MonitorRepositoryPackage.Literals.TIME_DRIVEN,
				 (EObject)timeDriven,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL",
				 "windowLength",
				 TIME_DRIVEN__WINDOW_LENGTH__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * The cached validation expression for the windowIncrement constraint of '<em>Time Driven</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String TIME_DRIVEN__WINDOW_INCREMENT__EEXPRESSION = "self.windowIncrement > 0.0";

	/**
	 * Validates the windowIncrement constraint of '<em>Time Driven</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateTimeDriven_windowIncrement(TimeDriven timeDriven, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(MonitorRepositoryPackage.Literals.TIME_DRIVEN,
				 (EObject)timeDriven,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL",
				 "windowIncrement",
				 TIME_DRIVEN__WINDOW_INCREMENT__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateVariableSizeAggregation(VariableSizeAggregation variableSizeAggregation, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)variableSizeAggregation, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)variableSizeAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)variableSizeAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)variableSizeAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)variableSizeAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)variableSizeAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)variableSizeAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)variableSizeAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)variableSizeAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(variableSizeAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validateMeasurementDrivenAggregation_frequency(variableSizeAggregation, diagnostics, context);
		if (result || diagnostics != null) result &= validateVariableSizeAggregation_retroLength(variableSizeAggregation, diagnostics, context);
		return result;
	}

	/**
	 * The cached validation expression for the retroLength constraint of '<em>Variable Size Aggregation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String VARIABLE_SIZE_AGGREGATION__RETRO_LENGTH__EEXPRESSION = "self.retrospectionLength > 0.0";

	/**
	 * Validates the retroLength constraint of '<em>Variable Size Aggregation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateVariableSizeAggregation_retroLength(VariableSizeAggregation variableSizeAggregation, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		return
			validate
				(MonitorRepositoryPackage.Literals.VARIABLE_SIZE_AGGREGATION,
				 (EObject)variableSizeAggregation,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL",
				 "retroLength",
				 VARIABLE_SIZE_AGGREGATION__RETRO_LENGTH__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateFeedThrough(FeedThrough feedThrough, DiagnosticChain diagnostics, Map<Object, Object> context)
	{
		if (!validate_NoCircularContainment((EObject)feedThrough, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms((EObject)feedThrough, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms((EObject)feedThrough, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained((EObject)feedThrough, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired((EObject)feedThrough, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves((EObject)feedThrough, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID((EObject)feedThrough, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique((EObject)feedThrough, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique((EObject)feedThrough, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_identifierIsUnique(feedThrough, diagnostics, context);
		return result;
	}

	/**
	 * Returns the resource locator that will be used to fetch messages for this validator's diagnostics.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator()
	{
		// TODO
		// Specialize this to return a resource locator for messages specific to this validator.
		// Ensure that you remove @generated or mark it @generated NOT
		return super.getResourceLocator();
	}

} //MonitorRepositoryValidator
