/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.monitorrepository.statisticalcharacterization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.measure.Measurable;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.monitorrepository.statisticalcharacterization.StatisticalCharacterizationAggregator;

public class MedianAggregator
extends StatisticalCharacterizationAggregator {
    public MedianAggregator(NumericalBaseMetricDescription expectedWindowMetric) {
        super(expectedWindowMetric);
    }

    @Override
    protected Measure<Double, Quantity> calculateStatisticalCharaterizationDiscrete(Iterable<MeasuringValue> windowData) {
        Double[] sortedData = (Double[])StreamSupport.stream(windowData.spliterator(), false).map(this::obtainDataValueFromMeasurement).sorted().toArray(Double[]::new);
        double median = 0.0;
        if (sortedData.length != 0) {
            int middle = sortedData.length / 2;
            median = sortedData.length % 2 == 0 ? 0.5 * (sortedData[middle] + sortedData[middle - 1]) : sortedData[middle];
        }
        return Measure.valueOf((double)median, this.getDataDefaultUnit());
    }

    @Override
    protected Measure<Double, Quantity> calculateStatisticalCharacterizationContinuous(Iterable<MeasuringValue> windowData) {
        Measure median = Measure.valueOf((double)0.0, this.getDataDefaultUnit());
        Iterator<MeasuringValue> iterator = windowData.iterator();
        ArrayList<Interval> intervalsInWindow = new ArrayList<Interval>();
        if (iterator.hasNext()) {
            MeasuringValue currentMeasurement = iterator.next();
            Optional<Object> nextMeasurement = null;
            do {
                nextMeasurement = iterator.hasNext() ? Optional.of(iterator.next()) : Optional.empty();
                intervalsInWindow.add(new Interval(this.obtainCurrentMeasurementValidityLength(currentMeasurement, nextMeasurement), this.obtainDataFromMeasurement(currentMeasurement)));
                if (!nextMeasurement.isPresent()) continue;
                currentMeasurement = nextMeasurement.get();
            } while (nextMeasurement.isPresent());
            Interval[] sortedIntervals = (Interval[])intervalsInWindow.stream().sorted().toArray(Interval[]::new);
            Amount[] sortedAreas = (Amount[])Arrays.stream(sortedIntervals).map(Interval::access$1).toArray(Amount[]::new);
            Arrays.parallelPrefix(sortedAreas, Amount::plus);
            Amount halfTotalArea = sortedAreas[sortedAreas.length - 1].divide(2L);
            int medianIndex = IntStream.range(0, sortedAreas.length).filter(index -> sortedAreas[index].compareTo((Measurable)halfTotalArea) >= 0).findFirst().orElseThrow(() -> new AssertionError((Object)"There must be a point where the aggregated area is larger than half of the total area!"));
            median = sortedIntervals[medianIndex].getValueAsMeasure().to(super.getDataDefaultUnit());
        }
        return median;
    }

    private static class Interval
    implements Comparable<Interval> {
        private final Amount<Duration> length;
        private final Amount<Quantity> value;

        private Interval(Amount<Duration> length, Amount<Quantity> value) {
            assert (length != null && value != null);
            this.length = length;
            this.value = value;
        }

        @Override
        public int compareTo(Interval o) {
            return this.value.compareTo(o.value);
        }

        private Measure<Double, Quantity> getValueAsMeasure() {
            return Measure.valueOf((double)this.value.doubleValue(this.value.getUnit()), (Unit)this.value.getUnit());
        }

        private Amount<Quantity> getArea() {
            return this.length.times(this.value);
        }

        static /* synthetic */ Amount access$1(Interval interval) {
            return interval.getArea();
        }
    }
}

