/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.monitorrepository.util;

import de.uka.ipd.sdq.identifier.Identifier;
import de.uka.ipd.sdq.identifier.util.IdentifierValidator;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.palladiosimulator.monitorrepository.Aggregation;
import org.palladiosimulator.monitorrepository.ArithmeticMean;
import org.palladiosimulator.monitorrepository.FeedThrough;
import org.palladiosimulator.monitorrepository.FixedSizeAggregation;
import org.palladiosimulator.monitorrepository.GeometricMean;
import org.palladiosimulator.monitorrepository.HarmonicMean;
import org.palladiosimulator.monitorrepository.MeasurementDrivenAggregation;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.Median;
import org.palladiosimulator.monitorrepository.Monitor;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.monitorrepository.ProcessingType;
import org.palladiosimulator.monitorrepository.StatisticalCharacterization;
import org.palladiosimulator.monitorrepository.TimeDriven;
import org.palladiosimulator.monitorrepository.TimeDrivenAggregation;
import org.palladiosimulator.monitorrepository.VariableSizeAggregation;

public class MonitorRepositoryValidator
extends EObjectValidator {
    public static final MonitorRepositoryValidator INSTANCE = new MonitorRepositoryValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.palladiosimulator.monitorrepository";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected IdentifierValidator identifierValidator = IdentifierValidator.INSTANCE;
    protected static final String MEASUREMENT_DRIVEN_AGGREGATION__FREQUENCY__EEXPRESSION = "self.frequency > 0";
    protected static final String FIXED_SIZE_AGGREGATION__MEAS_NUM__EEXPRESSION = "self.numberOfMeasurements > 0";
    protected static final String TIME_DRIVEN__WINDOW_LENGTH__EEXPRESSION = "self.windowLength > 0.0";
    protected static final String TIME_DRIVEN__WINDOW_INCREMENT__EEXPRESSION = "self.windowIncrement > 0.0";
    protected static final String VARIABLE_SIZE_AGGREGATION__RETRO_LENGTH__EEXPRESSION = "self.retrospectionLength > 0.0";

    protected EPackage getEPackage() {
        return MonitorRepositoryPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateMonitorRepository((MonitorRepository)value, diagnostics, context);
            }
            case 1: {
                return this.validateMonitor((Monitor)value, diagnostics, context);
            }
            case 2: {
                return this.validateMeasurementSpecification((MeasurementSpecification)value, diagnostics, context);
            }
            case 3: {
                return this.validateStatisticalCharacterization((StatisticalCharacterization)value, diagnostics, context);
            }
            case 4: {
                return this.validateArithmeticMean((ArithmeticMean)value, diagnostics, context);
            }
            case 5: {
                return this.validateHarmonicMean((HarmonicMean)value, diagnostics, context);
            }
            case 6: {
                return this.validateGeometricMean((GeometricMean)value, diagnostics, context);
            }
            case 7: {
                return this.validateMedian((Median)value, diagnostics, context);
            }
            case 8: {
                return this.validateProcessingType((ProcessingType)value, diagnostics, context);
            }
            case 9: {
                return this.validateAggregation((Aggregation)value, diagnostics, context);
            }
            case 10: {
                return this.validateMeasurementDrivenAggregation((MeasurementDrivenAggregation)value, diagnostics, context);
            }
            case 11: {
                return this.validateFixedSizeAggregation((FixedSizeAggregation)value, diagnostics, context);
            }
            case 12: {
                return this.validateTimeDrivenAggregation((TimeDrivenAggregation)value, diagnostics, context);
            }
            case 13: {
                return this.validateTimeDriven((TimeDriven)value, diagnostics, context);
            }
            case 14: {
                return this.validateVariableSizeAggregation((VariableSizeAggregation)value, diagnostics, context);
            }
            case 15: {
                return this.validateFeedThrough((FeedThrough)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateMonitorRepository(MonitorRepository monitorRepository, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)monitorRepository, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)monitorRepository, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)monitorRepository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)monitorRepository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)monitorRepository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)monitorRepository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)monitorRepository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)monitorRepository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)monitorRepository, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)monitorRepository, diagnostics, context);
        }
        return result;
    }

    public boolean validateMonitor(Monitor monitor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)monitor, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)monitor, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)monitor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)monitor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)monitor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)monitor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)monitor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)monitor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)monitor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)monitor, diagnostics, context);
        }
        return result;
    }

    public boolean validateMeasurementSpecification(MeasurementSpecification measurementSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)measurementSpecification, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)measurementSpecification, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)measurementSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)measurementSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)measurementSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)measurementSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)measurementSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)measurementSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)measurementSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)measurementSpecification, diagnostics, context);
        }
        return result;
    }

    public boolean validateStatisticalCharacterization(StatisticalCharacterization statisticalCharacterization, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)statisticalCharacterization, diagnostics, context);
    }

    public boolean validateArithmeticMean(ArithmeticMean arithmeticMean, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)arithmeticMean, diagnostics, context);
    }

    public boolean validateHarmonicMean(HarmonicMean harmonicMean, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)harmonicMean, diagnostics, context);
    }

    public boolean validateGeometricMean(GeometricMean geometricMean, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)geometricMean, diagnostics, context);
    }

    public boolean validateMedian(Median median, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)median, diagnostics, context);
    }

    public boolean validateProcessingType(ProcessingType processingType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)processingType, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)processingType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)processingType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)processingType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)processingType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)processingType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)processingType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)processingType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)processingType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)processingType, diagnostics, context);
        }
        return result;
    }

    public boolean validateAggregation(Aggregation aggregation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)aggregation, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)aggregation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)aggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)aggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)aggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)aggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)aggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)aggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)aggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)aggregation, diagnostics, context);
        }
        return result;
    }

    public boolean validateMeasurementDrivenAggregation(MeasurementDrivenAggregation measurementDrivenAggregation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)measurementDrivenAggregation, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)measurementDrivenAggregation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)measurementDrivenAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)measurementDrivenAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)measurementDrivenAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)measurementDrivenAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)measurementDrivenAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)measurementDrivenAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)measurementDrivenAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)measurementDrivenAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMeasurementDrivenAggregation_frequency(measurementDrivenAggregation, diagnostics, context);
        }
        return result;
    }

    public boolean validateMeasurementDrivenAggregation_frequency(MeasurementDrivenAggregation measurementDrivenAggregation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(MonitorRepositoryPackage.Literals.MEASUREMENT_DRIVEN_AGGREGATION, (EObject)measurementDrivenAggregation, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "frequency", MEASUREMENT_DRIVEN_AGGREGATION__FREQUENCY__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateFixedSizeAggregation(FixedSizeAggregation fixedSizeAggregation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)fixedSizeAggregation, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)fixedSizeAggregation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)fixedSizeAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)fixedSizeAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)fixedSizeAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)fixedSizeAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)fixedSizeAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)fixedSizeAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)fixedSizeAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)fixedSizeAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMeasurementDrivenAggregation_frequency(fixedSizeAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFixedSizeAggregation_measNum(fixedSizeAggregation, diagnostics, context);
        }
        return result;
    }

    public boolean validateFixedSizeAggregation_measNum(FixedSizeAggregation fixedSizeAggregation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(MonitorRepositoryPackage.Literals.FIXED_SIZE_AGGREGATION, (EObject)fixedSizeAggregation, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "measNum", FIXED_SIZE_AGGREGATION__MEAS_NUM__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateTimeDrivenAggregation(TimeDrivenAggregation timeDrivenAggregation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)timeDrivenAggregation, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)timeDrivenAggregation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)timeDrivenAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)timeDrivenAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)timeDrivenAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)timeDrivenAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)timeDrivenAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)timeDrivenAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)timeDrivenAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)timeDrivenAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTimeDriven_windowLength(timeDrivenAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTimeDriven_windowIncrement(timeDrivenAggregation, diagnostics, context);
        }
        return result;
    }

    public boolean validateTimeDriven(TimeDriven timeDriven, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)timeDriven, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)timeDriven, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)timeDriven, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)timeDriven, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)timeDriven, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)timeDriven, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)timeDriven, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)timeDriven, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)timeDriven, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)timeDriven, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTimeDriven_windowLength(timeDriven, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTimeDriven_windowIncrement(timeDriven, diagnostics, context);
        }
        return result;
    }

    public boolean validateTimeDriven_windowLength(TimeDriven timeDriven, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(MonitorRepositoryPackage.Literals.TIME_DRIVEN, (EObject)timeDriven, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "windowLength", TIME_DRIVEN__WINDOW_LENGTH__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateTimeDriven_windowIncrement(TimeDriven timeDriven, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(MonitorRepositoryPackage.Literals.TIME_DRIVEN, (EObject)timeDriven, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "windowIncrement", TIME_DRIVEN__WINDOW_INCREMENT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateVariableSizeAggregation(VariableSizeAggregation variableSizeAggregation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)variableSizeAggregation, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)variableSizeAggregation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)variableSizeAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)variableSizeAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)variableSizeAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)variableSizeAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)variableSizeAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)variableSizeAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)variableSizeAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)variableSizeAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMeasurementDrivenAggregation_frequency(variableSizeAggregation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateVariableSizeAggregation_retroLength(variableSizeAggregation, diagnostics, context);
        }
        return result;
    }

    public boolean validateVariableSizeAggregation_retroLength(VariableSizeAggregation variableSizeAggregation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(MonitorRepositoryPackage.Literals.VARIABLE_SIZE_AGGREGATION, (EObject)variableSizeAggregation, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "retroLength", VARIABLE_SIZE_AGGREGATION__RETRO_LENGTH__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateFeedThrough(FeedThrough feedThrough, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)feedThrough, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)feedThrough, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)feedThrough, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)feedThrough, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)feedThrough, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)feedThrough, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)feedThrough, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)feedThrough, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)feedThrough, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)feedThrough, diagnostics, context);
        }
        return result;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

