/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.monitorrepository.statisticalcharacterization;

import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.monitorrepository.statisticalcharacterization.StatisticalCharacterizationAggregator;

public class ArithmeticMeanAggregator
extends StatisticalCharacterizationAggregator {
    public ArithmeticMeanAggregator(NumericalBaseMetricDescription expectedWindowMetric) {
        super(expectedWindowMetric);
    }

    @Override
    protected Measure<Double, Quantity> calculateStatisticalCharaterizationDiscrete(Iterable<MeasuringValue> windowData) {
        double arithmeticMean = StreamSupport.stream(windowData.spliterator(), false).collect(Collectors.averagingDouble(this::obtainDataValueFromMeasurement));
        return Measure.valueOf((double)arithmeticMean, this.getDataDefaultUnit());
    }

    @Override
    protected Measure<Double, Quantity> calculateStatisticalCharacterizationContinuous(Iterable<MeasuringValue> windowData) {
        Amount area = Amount.valueOf((double)0.0, (Unit)this.getDataDefaultUnit().times((Unit)SI.SECOND));
        Iterator<MeasuringValue> iterator = windowData.iterator();
        if (iterator.hasNext()) {
            MeasuringValue currentMeasurement = iterator.next();
            Optional<Object> nextMeasurement = null;
            do {
                nextMeasurement = iterator.hasNext() ? Optional.of(iterator.next()) : Optional.empty();
                area = area.plus(this.obtainCurrentMeasurementValidityLength(currentMeasurement, nextMeasurement).times(this.obtainDataFromMeasurement(currentMeasurement)));
                if (!nextMeasurement.isPresent()) continue;
                currentMeasurement = nextMeasurement.get();
            } while (nextMeasurement.isPresent());
        }
        Amount arithmeticMean = area.divide(this.getIntervalLength());
        return Measure.valueOf((double)arithmeticMean.doubleValue(this.getDataDefaultUnit()), this.getDataDefaultUnit());
    }
}

