/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.probeframework;

import java.util.LinkedList;
import java.util.List;
import org.palladiosimulator.probeframework.calculator.ICalculatorFactory;
import org.palladiosimulator.probeframework.calculator.ICalculatorFactoryLegacyAdapter;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.probeframework.calculator.IObservableCalculatorRegistry;
import org.palladiosimulator.probeframework.calculator.RegisterCalculatorFactoryDecorator;

public class ProbeFrameworkContext {
    private final ICalculatorFactoryLegacyAdapter calculatorFactory;
    private final IObservableCalculatorRegistry calculatorRegistry;
    private final List<Runnable> cleanupTasks = new LinkedList<Runnable>();

    public ProbeFrameworkContext(IGenericCalculatorFactory calculatorFactory) {
        if (calculatorFactory == null) {
            throw new IllegalArgumentException("A valid calculator factory is required.");
        }
        if (calculatorFactory instanceof IObservableCalculatorRegistry) {
            this.calculatorRegistry = (IObservableCalculatorRegistry)((Object)calculatorFactory);
            this.calculatorFactory = ICalculatorFactoryLegacyAdapter.createDelegatingAdapter(calculatorFactory);
        } else {
            RegisterCalculatorFactoryDecorator decorator = new RegisterCalculatorFactoryDecorator(calculatorFactory);
            this.calculatorRegistry = decorator;
            this.calculatorFactory = ICalculatorFactoryLegacyAdapter.createDelegatingAdapter(decorator);
            this.cleanupTasks.add(decorator::finish);
        }
    }

    @Deprecated
    public ICalculatorFactory getCalculatorFactory() {
        return this.calculatorFactory;
    }

    public IGenericCalculatorFactory getGenericCalculatorFactory() {
        return this.calculatorFactory;
    }

    public IObservableCalculatorRegistry getCalculatorRegistry() {
        return this.calculatorRegistry;
    }

    public void finish() {
        this.cleanupTasks.forEach(Runnable::run);
    }
}

