/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.probeframework.calculator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.palladiosimulator.commons.designpatterns.AbstractObservable;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.CalculatorProbeSet;
import org.palladiosimulator.probeframework.calculator.CalculatorRegistryListener;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.probeframework.calculator.IObservableCalculatorRegistry;

public class RegisterCalculatorFactoryDecorator
extends AbstractObservable<CalculatorRegistryListener>
implements IGenericCalculatorFactory,
IObservableCalculatorRegistry {
    private final IGenericCalculatorFactory decoratedFactory;
    private final Set<Calculator> calculatorRegister = new HashSet<Calculator>();

    public RegisterCalculatorFactoryDecorator(IGenericCalculatorFactory decoratedFactory) {
        this.decoratedFactory = decoratedFactory;
    }

    public IGenericCalculatorFactory getDecoratedFactory() {
        return this.decoratedFactory;
    }

    @Override
    public Collection<Calculator> getRegisteredCalculators() {
        return Collections.unmodifiableCollection(this.calculatorRegister);
    }

    @Override
    public Calculator getCalculatorByMeasuringPointAndMetricDescription(MeasuringPoint mp, MetricDescription metric) {
        Calculator result = null;
        String measuringPointString = mp.getStringRepresentation();
        for (Calculator calc : this.calculatorRegister) {
            if (!calc.isCompatibleWith(metric) || !measuringPointString.equals(calc.getMeasuringPoint().getStringRepresentation())) continue;
            result = calc;
            break;
        }
        return result;
    }

    @Override
    public Collection<Calculator> getCalculatorsForMeasuringPoint(MeasuringPoint measuringPoint) {
        String measuringPointString = Objects.requireNonNull(measuringPoint, "Measuring point must not be null").getStringRepresentation();
        return this.calculatorRegister.stream().filter(calc -> calc.getMeasuringPoint().getStringRepresentation().equals(measuringPointString)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public void finish() {
        for (Calculator calculator : this.calculatorRegister) {
            calculator.preUnregister();
        }
        this.calculatorRegister.clear();
    }

    private Calculator register(Calculator calculator) {
        if (this.calculatorRegister.contains(calculator)) {
            Calculator found = null;
            for (Calculator calc : this.calculatorRegister) {
                if (!calc.equals(calculator)) continue;
                found = calc;
                break;
            }
            throw new IllegalArgumentException("Calculator \"" + calculator.getClass().getName() + " [" + calculator.getMeasuringPoint().getStringRepresentation() + "; " + calculator.getMetricDesciption().getName() + "]\" already in calculator registry as \"" + found.getClass().getName() + " [" + found.getMeasuringPoint().getStringRepresentation() + "; " + found.getMetricDesciption().getName() + "]\"");
        }
        this.calculatorRegister.add(calculator);
        ((CalculatorRegistryListener)this.getEventDispatcher()).notifyCalculatorRegistration(calculator);
        return calculator;
    }

    @Override
    public Calculator buildCalculator(MetricDescription metric, MeasuringPoint measuringPoint, CalculatorProbeSet probeConfiguration) {
        return this.register(this.decoratedFactory.buildCalculator(metric, measuringPoint, probeConfiguration));
    }
}

