/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.probeframework.calculator;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.Platform;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.CalculatorFactoryRegistryExtensionPoint;
import org.palladiosimulator.probeframework.calculator.CalculatorProbeSet;
import org.palladiosimulator.probeframework.calculator.CalculatorProbeSetBasedInferingCalculatorFactory;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;

public class ExtensibleCalculatorFactoryDelegatingFactory
implements IGenericCalculatorFactory {
    private final Map<String, IGenericCalculatorFactory> delegateFactories;
    private final IGenericCalculatorFactory fallbackFactory;

    public ExtensibleCalculatorFactoryDelegatingFactory() {
        this(Platform.isRunning() ? CalculatorFactoryRegistryExtensionPoint.INSTANCE.getCalculatorFactories() : Collections.emptyMap(), new CalculatorProbeSetBasedInferingCalculatorFactory());
    }

    public ExtensibleCalculatorFactoryDelegatingFactory(Map<String, IGenericCalculatorFactory> delegateFactories, IGenericCalculatorFactory fallbackFactory) {
        this.delegateFactories = Collections.unmodifiableMap(Objects.requireNonNull(delegateFactories));
        this.fallbackFactory = Objects.requireNonNull(fallbackFactory);
    }

    @Override
    public Calculator buildCalculator(MetricDescription metric, MeasuringPoint measuringPoint, CalculatorProbeSet probeConfiguration) {
        return this.delegateFactories.getOrDefault(metric.getId(), this.fallbackFactory).buildCalculator(metric, measuringPoint, probeConfiguration);
    }
}

