/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.recorderframework.edp2.config;

import java.util.Date;
import java.util.Map;
import org.palladiosimulator.commons.datastructureutils.MapHelper;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentDataFactory;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentSetting;
import org.palladiosimulator.edp2.models.ExperimentData.MeasuringType;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.recorderframework.edp2.config.AbstractEDP2RecorderConfigurationFactory;

public class EDP2RecorderConfigurationFactory
extends AbstractEDP2RecorderConfigurationFactory<ExperimentRun> {
    private ExperimentSetting experimentSetting;

    @Override
    public void initialize(Map<String, Object> configuration) {
        super.initialize(configuration);
        this.initializeExperimentSetting((String)MapHelper.getValue(configuration, (String)"variationId", String.class));
        this.initializeExperimentRun();
    }

    private void initializeExperimentRun() {
        this.experimentRun = ExperimentDataFactory.eINSTANCE.createExperimentRun();
        ((ExperimentRun)this.experimentRun).setStartTime(new Date());
        this.experimentSetting.getExperimentRuns().add((Object)((ExperimentRun)this.experimentRun));
        this.experimentGroup.getExperimentSettings().add((Object)this.experimentSetting);
    }

    private void initializeExperimentSetting(String variationID) {
        for (ExperimentSetting setting : this.experimentGroup.getExperimentSettings()) {
            if (!setting.getDescription().equals(variationID)) continue;
            this.experimentSetting = setting;
            return;
        }
        this.experimentSetting = ExperimentDataFactory.eINSTANCE.createExperimentSetting();
        this.experimentSetting.setDescription(variationID);
    }

    @Override
    protected MeasuringType createMeasuringType(MetricDescription measureMetric, MeasuringPoint measuringPoint) {
        MeasuringType measuringType = super.createMeasuringType(measureMetric, measuringPoint);
        measuringType.getExperimentSettings().add((Object)this.experimentSetting);
        return measuringType;
    }
}

