/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.adapter;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.AbstractPie;
import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.PieEntity;
import de.uka.ipd.sdq.sensorframework.adapter.DataAdapter;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.entities.StateSensor;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class StateSensorToPieAdapter
extends DataAdapter {
    private static final int FACTOR_PERCENT = 100;
    protected SensorAndMeasurements samInformation;

    protected StateSensorToPieAdapter(SensorAndMeasurements samInformation) {
        this.samInformation = samInformation;
    }

    @Override
    public Object getAdaptedObject() {
        HashMap<String, Double> fractions = new HashMap<String, Double>();
        double sum = this.calculateFractions(fractions);
        return this.createPie(fractions, sum);
    }

    private AbstractPie createPie(HashMap<String, Double> timeSums, double sum) {
        AbstractPie p = this.instantiatePie(((StateSensor)this.samInformation.getSensor()).getSensorName());
        DecimalFormat df = new DecimalFormat("#0.0", new DecimalFormatSymbols(Locale.US));
        for (Map.Entry<String, Double> e : timeSums.entrySet()) {
            if (!(e.getValue() > 0.0)) continue;
            p.addEntity(new PieEntity(e.getValue().doubleValue(), String.valueOf(e.getKey()) + " (" + df.format(e.getValue() * 100.0 / sum) + "%)"));
        }
        return p;
    }

    protected abstract double calculateFractions(HashMap<String, Double> var1);

    protected abstract AbstractPie instantiatePie(String var1);
}

