/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.adapter;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.Histogram;
import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.HistogramBucketInformation;
import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.TimeSeries;
import de.uka.ipd.sdq.sensorframework.adapter.DataAdapter;
import de.uka.ipd.sdq.sensorframework.adapter.TimeSpanToHistogramAdapter;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;

public class TimeSpanToQuantilAdapter
extends DataAdapter {
    private static final String FIRST_VALUE_BELOW = "FIRST_VALUE_BELOW";
    private static final String QUANTIL = "QUANTIL";
    private static final double DEFAULT_QUANTIL = 0.9;
    private static final double QUANTILE_FACTOR = 0.001;
    private final SensorAndMeasurements samInformation;

    public TimeSpanToQuantilAdapter(SensorAndMeasurements samInformation) {
        this.samInformation = samInformation;
        this.adapterProperties.put(FIRST_VALUE_BELOW, (Object)true);
        this.adapterProperties.put(QUANTIL, (Object)0.9);
    }

    @Override
    public Object getAdaptedObject() {
        TimeSpanToHistogramAdapter tstha = new TimeSpanToHistogramAdapter(this.samInformation);
        tstha.getProperties().put("HISTOGRAM_WIDTH", new Double(0.001));
        Histogram hist = (Histogram)tstha.getAdaptedObject();
        TimeSeries series = new TimeSeries(this.samInformation.getSensor().getSensorName());
        int counter = 0;
        double sum = 0.0;
        for (HistogramBucketInformation he : hist.getBucketInformation()) {
            if ((sum += he.getProbability()) >= (Double)this.adapterProperties.get(QUANTIL)) {
                if (((Boolean)this.adapterProperties.get(FIRST_VALUE_BELOW)).booleanValue() && counter > 0) {
                    he = (HistogramBucketInformation)hist.getBucketInformation().get(counter - 1);
                }
                series.add((double)this.samInformation.getSensor().getSensorID(), he.getValue());
                return series;
            }
            ++counter;
        }
        return series;
    }
}

