/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.adapter;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.AbstractPie;
import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.FrequencyFailurePie;
import de.uka.ipd.sdq.sensorframework.adapter.StateSensorToPieAdapter;
import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.entities.State;
import de.uka.ipd.sdq.sensorframework.entities.StateMeasurement;
import de.uka.ipd.sdq.sensorframework.entities.StateSensor;
import java.util.HashMap;

public class StateSensorToFrequencyFailurePieAdapter
extends StateSensorToPieAdapter {
    public StateSensorToFrequencyFailurePieAdapter(SensorAndMeasurements samInformation) {
        super(samInformation);
    }

    @Override
    protected double calculateFractions(HashMap<String, Double> fractions) {
        for (State state : ((StateSensor)this.samInformation.getSensor()).getSensorStates()) {
            if (state.getStateLiteral().equals("Success")) continue;
            fractions.put(state.getStateLiteral(), 0.0);
        }
        int failureCounter = 0;
        for (Measurement m : this.samInformation.getMeasurements()) {
            StateMeasurement sm = (StateMeasurement)m;
            if (sm.getSensorState().getStateLiteral().equals("Success")) continue;
            ++failureCounter;
            double oldValue = fractions.get(sm.getSensorState().getStateLiteral());
            double newValue = oldValue + 1.0;
            fractions.put(sm.getSensorState().getStateLiteral(), newValue);
        }
        return failureCounter;
    }

    @Override
    protected AbstractPie instantiatePie(String sensorName) {
        return new FrequencyFailurePie(sensorName);
    }
}

