package de.uka.ipd.sdq.sensorframework.dao.file.entities;

import java.util.HashMap;
import java.util.Map;

import de.uka.ipd.sdq.sensorframework.entities.ScalabilityExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;

/**
 * Entity implementation for scalability Experiment Runs. Contains BackgroundMemoryLists to quickly
 * store the huge amounts of sensor data generated by simulations.
 * 
 * @author Paul-Remis Beauvais
 * @deprecated Superseded by EDP2.
 */
public class ScalabilityExperimentRunImpl extends ExperimentRunImpl implements ScalabilityExperimentRun {

    private static final long serialVersionUID = 8596657460961660218L;

    private String[] paramNames = null;

    private final Map<String, Integer> constParameters = new HashMap<String, Integer>();

    public ScalabilityExperimentRunImpl(IDAOFactory factory) {
        super(factory);
    }

    @Override
    public void addConstParameter(String paramName, int paramValue) {
        constParameters.put(paramName, paramValue);
    }

    @Override
    public Map<String, Integer> getConstParameters() {
        return constParameters;
    }

    @Override
    public String[] getVarParameterNames() {
        return paramNames;
    }

    @Override
    public void setVarParameterNames(String[] names) {
        paramNames = names;
    }

}
