/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.storage.lists;

import de.uka.ipd.sdq.sensorframework.storage.lists.Chunk;
import de.uka.ipd.sdq.sensorframework.storage.lists.ISerialiser;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;

public class BackgroundMemoryList<T>
extends AbstractList<T>
implements List<T>,
RandomAccess {
    public static final int MEMORY_CHUNKS_SIZE = 10000;
    private Chunk<T> currentChunk = null;
    private RandomAccessFile raf = null;
    boolean isClosed = true;
    private ISerialiser<T> serialiser;
    private int listSize;

    public BackgroundMemoryList(String filename, ISerialiser<T> serialiser) throws IOException {
        this(new File(filename), serialiser);
    }

    public BackgroundMemoryList(File f, ISerialiser<T> serialiser) throws IOException {
        this.raf = new RandomAccessFile(f, "rw");
        this.isClosed = false;
        this.serialiser = serialiser;
        this.initListSize();
    }

    @Override
    public synchronized void add(int index, T e) {
        try {
            this.ensureCorrectChunkLoaded(index);
            if (this.currentChunk == null || this.currentChunk.isFull()) {
                this.flush();
                this.currentChunk = new Chunk<T>(this.raf, this.serialiser);
            }
            this.currentChunk.add(e);
            ++this.listSize;
        }
        catch (IOException ex) {
            throw new RuntimeException("Background List failed", ex);
        }
    }

    @Override
    public synchronized T get(int index) {
        if (this.isClosed) {
            throw new IllegalStateException("Tryed to get data from a closed background list");
        }
        if (index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Read behind background list length");
        }
        try {
            this.ensureCorrectChunkLoaded(index);
            return this.currentChunk.get((int)((long)index - this.currentChunk.fromElement()));
        }
        catch (IOException ex) {
            throw new RuntimeException("Background List failed", ex);
        }
    }

    private void ensureCorrectChunkLoaded(int index) throws IOException {
        if (this.currentChunk != null && this.currentChunk.accepts(index)) {
            return;
        }
        this.flush();
        this.currentChunk = new Chunk<T>(this.raf, this.serialiser, index / 10000);
    }

    @Override
    public synchronized int size() {
        return this.listSize;
    }

    private void initListSize() {
        try {
            if (this.currentChunk != null && !this.currentChunk.isFull()) {
                this.listSize = (int)(this.raf.length() / (this.serialiser.getElementLength() * 10000L) + (long)this.currentChunk.size());
            }
            this.listSize = (int)(this.raf.length() / this.serialiser.getElementLength());
        }
        catch (IOException e) {
            throw new RuntimeException("Background list failed unexpectedly", e);
        }
    }

    public synchronized void close() throws IOException {
        if (!this.isClosed) {
            this.flush();
            this.raf.close();
            this.isClosed = true;
        }
    }

    public synchronized void flush() throws IOException {
        if (this.currentChunk != null) {
            this.currentChunk.persist();
        }
        this.currentChunk = null;
    }
}

