/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation;

import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.IUtilizationSeriesExporter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;

public class ExportCSVUtilization
extends Action {
    private static final Logger LOGGER = Logger.getLogger(ExportCSVUtilization.class);
    private final IUtilizationSeriesExporter viewer;

    public ExportCSVUtilization(IUtilizationSeriesExporter freeChartUtilizationViewer) {
        this.setText("Export Utilization CSV...");
        this.viewer = freeChartUtilizationViewer;
    }

    public void run() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
        dialog.open();
        if (dialog.getFileName() != null) {
            this.exportCSVUtilization(String.valueOf(dialog.getFilterPath()) + File.separatorChar + dialog.getFileName(), this.viewer);
        }
    }

    private void exportCSVUtilization(String filename, IUtilizationSeriesExporter viewer) {
        XYSeries series = viewer.getSeries();
        double width = viewer.getUtilizationWidth();
        try {
            FileWriter fileWriter = new FileWriter(filename);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            for (Object item : series.getItems()) {
                XYDataItem data = (XYDataItem)item;
                bufferedWriter.append(String.valueOf(("" + data.getY()).replace(".", ",")) + ";" + String.valueOf(data.getX().doubleValue() - 0.5 * width).replace(".", ",") + ";" + String.valueOf(data.getX().doubleValue() + 0.5 * width).replace(".", ",") + "\n");
            }
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error writing CSV file.", (Throwable)e);
        }
    }
}

