/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.editor;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.Utilization;
import de.uka.ipd.sdq.sensorframework.adapter.DataAdapter;
import de.uka.ipd.sdq.sensorframework.visualisation.IVisualisation;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.AbstractReportView;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.AbstractJFreeChartUtilizationWidthViewer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractJFreeChartUtilizationWidthReport
extends AbstractReportView
implements IVisualisation<Utilization> {
    AbstractJFreeChartUtilizationWidthViewer viewer;
    protected Text widthInput;
    protected double utilizationWidth = Double.NaN;
    private List<DataAdapter> adapterList = null;

    protected abstract AbstractJFreeChartUtilizationWidthViewer createViewer(Composite var1, int var2);

    protected void createReportControls(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        Composite utilizationWidthPanel = new Composite(parent, 0);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        utilizationWidthPanel.setLayoutData((Object)data);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = false;
        rowLayout.pack = true;
        utilizationWidthPanel.setLayout((Layout)rowLayout);
        Label label = new Label(utilizationWidthPanel, 0x1000000);
        label.setText("Sampling Rate");
        label.setLayoutData((Object)new RowData(-1, -1));
        this.widthInput = new Text(utilizationWidthPanel, 2048);
        this.widthInput.setText(Double.toString(this.utilizationWidth));
        this.widthInput.setLayoutData((Object)new RowData(60, -1));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: {
                        if (event.character != '\r') break;
                        AbstractJFreeChartUtilizationWidthReport.this.updateUtilizationWidth(Double.parseDouble(AbstractJFreeChartUtilizationWidthReport.this.widthInput.getText()));
                        break;
                    }
                    case 16: {
                        AbstractJFreeChartUtilizationWidthReport.this.updateUtilizationWidth(Double.parseDouble(AbstractJFreeChartUtilizationWidthReport.this.widthInput.getText()));
                    }
                }
            }
        };
        this.widthInput.addListener(1, listener);
        this.widthInput.addListener(16, listener);
        this.viewer = this.createViewer(parent, 0);
        GridData data2 = new GridData();
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = true;
        data2.verticalAlignment = 4;
        data2.horizontalAlignment = 4;
        this.viewer.setLayoutData(data2);
        utilizationWidthPanel.setLayoutData((Object)data);
    }

    private void updateUtilizationWidth(double newWidth) {
        this.utilizationWidth = newWidth;
        this.setIgnoreDataSettingsChanged(true);
        for (DataAdapter adapter : this.adapterList) {
            Properties adapterProperties = adapter.getProperties();
            adapterProperties.put("UTILIZATION_WIDTH", (Object)this.utilizationWidth);
            adapter.setProperties(adapterProperties);
        }
        this.setIgnoreDataSettingsChanged(false);
        this.generateVisualization(this.adapterList);
    }

    @Override
    public void setInput(Collection<Utilization> utilization) {
        this.viewer.setData(utilization);
        this.widthInput.setText("" + this.utilizationWidth);
    }

    protected void generateVisualization(List<DataAdapter> newList) {
        if (newList == null || newList.isEmpty()) {
            throw new RuntimeException("Utilization reports must have at least one data input.");
        }
        Properties adapterProperties = null;
        double newWidth = Double.NaN;
        if (this.adapterList != null && !this.adapterList.isEmpty()) {
            adapter = this.adapterList.get(0);
            adapterProperties = adapter.getProperties();
            Double test = (Double)adapterProperties.get("UTILIZATION_WIDTH");
            newWidth = test;
        } else {
            adapter = newList.get(0);
            adapterProperties = adapter.getProperties();
            newWidth = (Double)adapterProperties.get("UTILIZATION_WIDTH");
        }
        boolean allSameWidth = this.isSameWidth(newList);
        ArrayList<Utilization> newUtilizationList = new ArrayList<Utilization>();
        for (DataAdapter adapter : newList) {
            if (!allSameWidth) {
                adapterProperties = adapter.getProperties();
                adapterProperties.put("UTILIZATION_WIDTH", (Object)newWidth);
                adapter.setProperties(adapterProperties);
            }
            newUtilizationList.add((Utilization)adapter.getAdaptedObject());
        }
        this.utilizationWidth = newWidth;
        this.adapterList = newList;
        this.setInput((Collection<Utilization>)newUtilizationList);
    }

    private boolean isSameWidth(List<DataAdapter> adapterList) {
        boolean allSameWidth = true;
        double width = Double.NaN;
        double currentWidth = Double.NaN;
        for (DataAdapter adapter : adapterList) {
            Properties adapterProperties = adapter.getProperties();
            currentWidth = (Double)adapterProperties.get("UTILIZATION_WIDTH");
            if (Double.isNaN(width)) {
                width = currentWidth;
            }
            if (width == currentWidth) continue;
            allSameWidth = false;
        }
        return allSameWidth;
    }

    public void setFocus() {
        this.viewer.setFocus();
    }

    @Override
    public void addInput(Collection<Utilization> c) {
    }

    @Override
    public void deleteInput(Collection<Utilization> c) {
    }
}

