/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation;

import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.ISeriesExporter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;

public class ExportCSV
extends Action {
    private static final Logger LOGGER = Logger.getLogger(ExportCSV.class);
    private final ISeriesExporter viewer;

    public ExportCSV(ISeriesExporter freeChartHistogramViewer) {
        this.setText("Export CSV...");
        this.viewer = freeChartHistogramViewer;
    }

    public void run() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
        dialog.open();
        if (dialog.getFileName() != null) {
            this.exportCSV(String.valueOf(dialog.getFilterPath()) + File.separatorChar + dialog.getFileName(), this.viewer.getSeries());
        }
    }

    private void exportCSV(String filename, XYSeries series) {
        try {
            FileWriter fileWriter = new FileWriter(filename);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            for (Object item : series.getItems()) {
                XYDataItem data = (XYDataItem)item;
                bufferedWriter.append((data.getX() + ";" + data.getY() + "\n").replace(".", ","));
            }
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error writing CSV file.", (Throwable)e);
        }
    }
}

