/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.Histogram;
import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.HistogramBucketInformation;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.AbstractJFreeChartWidthViewer;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.ExportCSV;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.IHistogramAccepter;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.ISeriesExporter;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.LoadCSVHistogram;
import java.awt.BasicStroke;
import java.awt.Stroke;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Composite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;

public class JFreeChartCDFViewer
extends AbstractJFreeChartWidthViewer
implements IHistogramAccepter,
ISeriesExporter {
    @Override
    public XYSeries getSeries() {
        return this.densityDataset.getSeries(0);
    }

    public JFreeChartCDFViewer(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initializeContextMenu(MenuManager menu_manager) {
        super.initializeContextMenu(menu_manager);
        menu_manager.add((IAction)new LoadCSVHistogram(this));
        menu_manager.add((IAction)new ExportCSV(this));
    }

    @Override
    public void addHistogram(Histogram histogram) {
        XYSeries density = new XYSeries((Comparable)((Object)histogram.getTitle()), true, false);
        double sum = 0.0;
        for (HistogramBucketInformation e : histogram.getBucketInformation()) {
            density.add(e.getValue(), sum += e.getProbability());
        }
        this.densityDataset.addSeries(density);
        this.initChart();
        this.redraw();
    }

    @Override
    protected void initChart() {
        this.chart = ChartFactory.createXYLineChart((String)"Cumulative Distribution Function", (String)"Time", (String)"Probability", (XYDataset)this.densityDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.getRangeAxis().setAutoRange(true);
        plot.getRenderer().setStroke((Stroke)new BasicStroke(3.0f));
    }

    @Override
    protected XYSeries computeDensities(Histogram hist) {
        double sum = 0.0;
        XYSeries density = new XYSeries((Comparable)((Object)hist.getTitle()), true, false);
        for (HistogramBucketInformation bucketInformation : hist.getBucketInformation()) {
            if (sum == 0.0) {
                density.add(bucketInformation.getValue(), sum);
            }
            if ((sum += bucketInformation.getProbability()) == 0.0) continue;
            density.add(bucketInformation.getValue() + hist.getBucketWidth(), sum);
        }
        return density;
    }
}

