/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.reportitems;

import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.RVisualisationPlugin;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.reportitems.AbstractRReportItem;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.reportitems.IReportRenderingVisitor;
import de.uka.ipd.sdq.sensorframework.visualisation.rvisualisation.utils.RConnection;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;

public abstract class AbstractPlotReportItem
extends AbstractRReportItem {
    public static final LegendPosition DEFAULT_LEGEND_POSITION = LegendPosition.none;
    public static final int DEFAULT_GRAPHIC_SIZE = 500;
    public static final int DEFAULT_FONT_SIZE = 12;
    private Map<String, String> dataCommandTable = new Hashtable<String, String>();
    private Map<String, String> nameTable = new Hashtable<String, String>();
    private File temporaryRasterGraphicFile = null;
    private File temporaryVectorGraphicFile = null;
    private LegendPosition legendPosition = DEFAULT_LEGEND_POSITION;
    private String[] colors = new String[]{"black", "lightgray", "darkgray", "gray"};
    private int graphicsHeight = 500;
    private int graphicsWidth = 500;
    private int fontSize = 12;

    public AbstractPlotReportItem(String title) {
        super(title);
    }

    public AbstractPlotReportItem(String title, int height, int width, int fontSize) {
        super(title);
        this.graphicsWidth = width;
        this.graphicsHeight = height;
        this.fontSize = fontSize;
    }

    public void addData(String id, String displayName, String rVariable) {
        this.dataCommandTable.put(id, rVariable);
        this.nameTable.put(id, displayName);
    }

    public void removeData(String id) {
        this.dataCommandTable.remove(id);
        this.nameTable.remove(id);
    }

    protected String[] getDataSeries() {
        Object[] identifiers = new String[this.dataCommandTable.keySet().size()];
        this.dataCommandTable.keySet().toArray(identifiers);
        Arrays.sort(identifiers);
        return identifiers;
    }

    protected String getName(String id) {
        return this.nameTable.get(id);
    }

    protected String getDataCommand(String id) {
        return this.dataCommandTable.get(id);
    }

    @Override
    public void visit(IReportRenderingVisitor v) {
        v.visitGraphicReportItem(this);
    }

    public String getTemporaryRasterGraphicFilename() {
        if (this.dataCommandTable.size() == 0) {
            return null;
        }
        return this.temporaryRasterGraphicFile.getAbsolutePath();
    }

    public String getTemporaryVectorGraphicFilename() {
        if (this.dataCommandTable.size() == 0) {
            return null;
        }
        return this.temporaryVectorGraphicFile.getAbsolutePath();
    }

    protected abstract String generatePlotCommand();

    public void generateVectorGraphic(File pdfFile, RConnection rConnection) {
        String rCommand = "";
        try {
            rCommand = String.valueOf(rCommand) + "pdf(\"" + pdfFile.getAbsolutePath().replace("\\", "\\\\") + "\")\n";
            rCommand = String.valueOf(rCommand) + this.generatePlotCommand();
            rCommand = String.valueOf(rCommand) + "dev.off()\n";
        }
        catch (Exception e) {
            RVisualisationPlugin.log(4, "Could not create PDF file. " + e.getClass().getCanonicalName());
        }
        rConnection.execute(rCommand);
    }

    public void generateRasterGraphic(File pngFile, RConnection rConnection) {
        String rCommand = "";
        try {
            rCommand = String.valueOf(rCommand) + "png(\"" + pngFile.getAbsolutePath().replace("\\", "\\\\") + "\",height=" + this.graphicsHeight + ",width=" + this.graphicsWidth + ",pointsize=" + this.fontSize + ")\n";
            rCommand = String.valueOf(rCommand) + this.generatePlotCommand();
            rCommand = String.valueOf(rCommand) + "dev.off()\n";
        }
        catch (Exception e) {
            RVisualisationPlugin.log(4, "Could not create temporary graphic file. " + e.getClass().getCanonicalName());
        }
        rConnection.execute(rCommand);
    }

    @Override
    public void generateData(RConnection connection) {
        try {
            this.temporaryRasterGraphicFile = File.createTempFile("pcm_pic", ".png");
            this.temporaryRasterGraphicFile.deleteOnExit();
            this.generateRasterGraphic(this.temporaryRasterGraphicFile, connection);
        }
        catch (IOException e) {
            RVisualisationPlugin.log(4, "Could not create temporary raster graphic file. " + e.getClass().getCanonicalName());
        }
        try {
            this.temporaryVectorGraphicFile = File.createTempFile("pcm_pic", ".pdf");
            this.temporaryVectorGraphicFile.deleteOnExit();
            this.generateVectorGraphic(this.temporaryVectorGraphicFile, connection);
        }
        catch (IOException e) {
            RVisualisationPlugin.log(4, "Could not create temporary vector graphic file. " + e.getClass().getCanonicalName());
        }
    }

    protected String generateLinesLegend() {
        if (this.legendPosition == LegendPosition.none) {
            return "";
        }
        int pos = 0;
        String lines = "c(";
        String legend = "c(";
        String[] stringArray = this.getDataSeries();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            String name = this.getName(id);
            String sep = pos == 0 ? "" : ", ";
            lines = String.valueOf(lines) + sep + (pos + 1);
            legend = String.valueOf(legend) + sep + "\"" + name + "\"";
            ++pos;
            ++n2;
        }
        lines = String.valueOf(lines) + ")";
        legend = String.valueOf(legend) + ")";
        return "legend(\"" + (Object)((Object)this.legendPosition) + "\", " + legend + ", lty=" + lines + ", bg='white')\n";
    }

    protected String generateColorsLegend() {
        if (this.legendPosition == LegendPosition.none) {
            return "";
        }
        int pos = 0;
        String fill = "c(";
        String legend = "c(";
        String[] stringArray = this.getDataSeries();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            String name = this.getName(id);
            String sep = pos == 0 ? "" : ", ";
            fill = String.valueOf(fill) + sep + "\"" + this.colors[pos % this.colors.length] + "\"";
            legend = String.valueOf(legend) + sep + "\"" + name + "\"";
            ++pos;
            ++n2;
        }
        fill = String.valueOf(fill) + ")";
        legend = String.valueOf(legend) + ")";
        return "legend(\"" + (Object)((Object)this.legendPosition) + "\", " + legend + ", fill=" + fill + ", bg='white')\n";
    }

    public void setLegendPos(LegendPosition newLegendPosition) {
        this.legendPosition = newLegendPosition;
    }

    public static enum LegendPosition {
        none,
        top,
        topright,
        right,
        bottomright,
        bottom,
        bottomleft,
        left,
        topleft,
        center;

    }
}

