/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.dialogs;

import de.uka.ipd.sdq.sensorframework.SensorFrameworkDataset;
import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import de.uka.ipd.sdq.sensorframework.entities.dao.IExperimentDAO;
import de.uka.ipd.sdq.sensorframework.visualisation.views.ExperimentAndDAO;
import de.uka.ipd.sdq.sensorframework.visualisation.views.TreeObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ExperimentRunsDialogContentProvider
implements ITreeContentProvider {
    private List<IDAOFactory> root;

    public Object[] getChildren(Object parent) {
        if (parent instanceof ArrayList) {
            return ((ArrayList)parent).toArray();
        }
        if (parent instanceof IDAOFactory) {
            IExperimentDAO experimentDAO = ((IDAOFactory)parent).createExperimentDAO();
            return this.createExperimentAndDAOList((IDAOFactory)parent, experimentDAO.getExperiments()).toArray();
        }
        if (parent instanceof ExperimentAndDAO) {
            ExperimentAndDAO experiment = (ExperimentAndDAO)parent;
            Collection runs = experiment.getExperiment().getExperimentRuns();
            Object[] objects = new Object[runs.size()];
            int i = 0;
            for (ExperimentRun r : runs) {
                objects[i++] = new TreeObject(r, experiment.getDatasource(), experiment.getExperiment());
            }
            return objects;
        }
        return new Object[0];
    }

    private List<ExperimentAndDAO> createExperimentAndDAOList(IDAOFactory dao, Collection<Experiment> experiments) {
        ArrayList<ExperimentAndDAO> result = new ArrayList<ExperimentAndDAO>();
        for (Experiment e : experiments) {
            result.add(new ExperimentAndDAO(dao, e));
        }
        return result;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        TreeObject object;
        return !(element instanceof TreeObject) || !((object = (TreeObject)element).getObject() instanceof ExperimentRun);
    }

    public Object[] getElements(Object inputElement) {
        if (this.root == null) {
            this.root = new ArrayList<IDAOFactory>();
            this.root.addAll(SensorFrameworkDataset.singleton().getDataSources());
        }
        return this.getChildren(this.root);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

